/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.launch.transformer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.util.CheckClassAdapter;
import org.spongepowered.common.launch.transformer.SpongeSuperclassRegistry;

public class SpongeSuperclassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String superclass = SpongeSuperclassRegistry.getSuperclass(name);
        if (superclass != null) {
            ClassNode node = this.readClass(basicClass);
            node.methods.stream().forEach(m -> this.transformMethod((MethodNode)m, name, node.superName, superclass));
            node.superName = superclass;
            node.accept(new CheckClassAdapter(new ClassWriter(0)));
            ClassWriter writer = new ClassWriter(0);
            node.accept(writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private void transformMethod(MethodNode node, String name, String originalSuperclass, String superClass) {
        for (MethodInsnNode insn : this.findSuper(node, originalSuperclass, name)) {
            insn.owner = superClass;
        }
    }

    private List<MethodInsnNode> findSuper(MethodNode method, String originalSuperClass, String name) {
        ArrayList<MethodInsnNode> nodes = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode node : method.instructions.toArray()) {
            if (node.getOpcode() != 183 || !originalSuperClass.equals(((MethodInsnNode)node).owner)) continue;
            nodes.add((MethodInsnNode)node);
        }
        return nodes;
    }

    private ClassNode readClass(byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept(classNode, 0);
        return classNode;
    }
}

