/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancement;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.AdvancementEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.interfaces.advancement.IMixinAdvancementProgress;
import org.spongepowered.common.interfaces.advancement.IMixinCriterion;
import org.spongepowered.common.interfaces.advancement.IMixinCriterionProgress;
import org.spongepowered.common.interfaces.advancement.IMixinPlayerAdvancements;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={PlayerAdvancements.class})
public class MixinPlayerAdvancements
implements IMixinPlayerAdvancements {
    @Shadow
    @Final
    private Map<net.minecraft.advancements.Advancement, AdvancementProgress> field_192758_f;
    @Shadow
    private EntityPlayerMP field_192762_j;
    private boolean wasSuccess;
    @Nullable
    private Text message;

    @Inject(method={"startProgress"}, at={@At(value="HEAD")})
    private void onStartProgress(net.minecraft.advancements.Advancement advancement, AdvancementProgress progress, CallbackInfo ci) {
        IMixinAdvancementProgress advancementProgress = (IMixinAdvancementProgress)progress;
        advancementProgress.setAdvancement(((Advancement)advancement).getId());
        advancementProgress.setPlayerAdvancements((PlayerAdvancements)this);
    }

    @Redirect(method={"registerListeners(Lnet/minecraft/advancements/Advancement;)V"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/advancements/CriterionProgress;isObtained()Z"))
    private boolean onUnregisterListenersGetProgress(net.minecraft.advancements.CriterionProgress progress) {
        IMixinCriterionProgress mixinCriterionProgress = (IMixinCriterionProgress)progress;
        if (SpongeImplHooks.isFakePlayer((Entity)this.field_192762_j) || !mixinCriterionProgress.isCriterionAvailable()) {
            return progress.func_192151_a();
        }
        AdvancementCriterion criterion = ((CriterionProgress)progress).getCriterion();
        IMixinCriterion mixinCriterion = (IMixinCriterion)((Object)criterion);
        if (mixinCriterion.getScoreCriterion() != null) {
            return ((IMixinCriterionProgress)progress).getAdvancementProgress().get(mixinCriterion.getScoreCriterion()).get().achieved();
        }
        return progress.func_192151_a();
    }

    @Nullable
    @Redirect(method={"unregisterListeners"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/advancements/AdvancementProgress;getCriterionProgress(Ljava/lang/String;)Lnet/minecraft/advancements/CriterionProgress;"))
    private net.minecraft.advancements.CriterionProgress onUnregisterListenersGetProgress(AdvancementProgress advancementProgress, String criterion) {
        if (SpongeImplHooks.isFakePlayer((Entity)this.field_192762_j)) {
            return advancementProgress.func_192106_c(criterion);
        }
        Advancement advancement = ((org.spongepowered.api.advancement.AdvancementProgress)advancementProgress).getAdvancement();
        AdvancementCriterion advancementCriterion = (AdvancementCriterion)((net.minecraft.advancements.Advancement)advancement).func_192073_f().get(criterion);
        IMixinCriterion mixinCriterion = (IMixinCriterion)((Object)advancementCriterion);
        if (mixinCriterion.getScoreCriterion() != null && !((org.spongepowered.api.advancement.AdvancementProgress)advancementProgress).get(mixinCriterion.getScoreCriterion()).get().achieved()) {
            return null;
        }
        return advancementProgress.func_192106_c(criterion);
    }

    @Override
    public Set<AdvancementTree> getAdvancementTrees() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<net.minecraft.advancements.Advancement, AdvancementProgress> entry : this.field_192758_f.entrySet()) {
            Advancement advancement = (Advancement)entry.getKey();
            if (advancement.getParent().isPresent()) continue;
            advancement.getTree().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    @Redirect(method={"grantCriterion"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V"))
    private void onSendAdvancementMessage(PlayerList list, ITextComponent component) {
        this.message = SpongeTexts.toText(component);
        this.wasSuccess = true;
    }

    @Inject(method={"grantCriterion"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/AdvancementRewards;apply(Lnet/minecraft/entity/player/EntityPlayerMP;)V")})
    private void onAdvancementGranted(net.minecraft.advancements.Advancement advancement, String string, CallbackInfoReturnable<Boolean> ci) {
        this.wasSuccess = true;
    }

    @Inject(method={"grantCriterion"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/PlayerAdvancements;ensureVisibility(Lnet/minecraft/advancements/Advancement;)V")})
    private void fireAdvancementGrant(net.minecraft.advancements.Advancement advancement, String string, CallbackInfoReturnable<Boolean> ci) {
        MessageEvent.MessageFormatter formatter;
        MessageChannel channel;
        if (!this.wasSuccess) {
            return;
        }
        Instant instant = Instant.now();
        if (this.message != null) {
            channel = MessageChannel.TO_ALL;
            formatter = new MessageEvent.MessageFormatter(this.message);
        } else {
            channel = MessageChannel.TO_NONE;
            formatter = new MessageEvent.MessageFormatter();
            formatter.clear();
        }
        AdvancementEvent.Grant event = SpongeEventFactory.createAdvancementEventGrant(Sponge.getCauseStackManager().getCurrentCause(), channel, Optional.of(channel), (Advancement)advancement, formatter, (Player)this.field_192762_j, instant, false);
        SpongeImpl.postEvent(event);
        if (!event.isMessageCancelled() && !event.getMessage().isEmpty()) {
            event.getChannel().ifPresent(eventChannel -> eventChannel.send(this.field_192762_j, event.getMessage()));
        }
        this.message = null;
        this.wasSuccess = false;
    }

    @Override
    public Player getPlayer() {
        return (Player)this.field_192762_j;
    }

    @Override
    public void reloadAdvancementProgress() {
        for (AdvancementProgress progress : this.field_192758_f.values()) {
            ((IMixinAdvancementProgress)progress).updateProgressMap();
        }
    }
}

