/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableRailDirectionData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeRailDirectionData;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockRailBase.class})
public abstract class MixinBlockRailBase
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        ImmutableRailDirectionData railDirection = this.getRailDirectionFor(blockState);
        if (railDirection == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)railDirection);
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableRailDirectionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableRailDirectionData) {
            BlockRailBase.EnumRailDirection railDirection = (BlockRailBase.EnumRailDirection)((ImmutableRailDirectionData)manipulator).type().get();
            if (blockState.func_177230_c() instanceof BlockRail) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)railDirection));
            }
            if (blockState.func_177230_c() instanceof BlockRailPowered) {
                if (!BlockRailPowered.field_176568_b.func_177700_c().contains(railDirection)) {
                    return Optional.empty();
                }
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRailPowered.field_176568_b, (Comparable)railDirection));
            }
            if (blockState.func_177230_c() instanceof BlockRailDetector) {
                if (!BlockRailDetector.field_176573_b.func_177700_c().contains(railDirection)) {
                    return Optional.empty();
                }
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRailDetector.field_176573_b, (Comparable)railDirection));
            }
            for (Map.Entry entry : blockState.func_177228_b().entrySet()) {
                if (!(entry.getValue() instanceof BlockRailBase.EnumRailDirection) || !((IProperty)entry.getKey()).func_177700_c().contains(railDirection)) continue;
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)entry.getKey(), (Comparable)railDirection));
            }
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.RAIL_DIRECTION)) {
            BlockRailBase.EnumRailDirection railDirection = (BlockRailBase.EnumRailDirection)value;
            if (blockState.func_177230_c() instanceof BlockRail) {
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)railDirection));
            }
            if (blockState.func_177230_c() instanceof BlockRailPowered) {
                if (!BlockRailPowered.field_176568_b.func_177700_c().contains(railDirection)) {
                    return Optional.empty();
                }
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRailPowered.field_176568_b, (Comparable)railDirection));
            }
            if (blockState.func_177230_c() instanceof BlockRailDetector) {
                if (!BlockRailDetector.field_176573_b.func_177700_c().contains(railDirection)) {
                    return Optional.empty();
                }
                return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRailDetector.field_176573_b, (Comparable)railDirection));
            }
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableRailDirectionData getRailDirectionFor(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockRail) {
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, blockState.func_177229_b((IProperty)BlockRail.field_176565_b));
        }
        if (blockState.func_177230_c() instanceof BlockRailPowered) {
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, blockState.func_177229_b((IProperty)BlockRailPowered.field_176568_b));
        }
        if (blockState.func_177230_c() instanceof BlockRailDetector) {
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, blockState.func_177229_b((IProperty)BlockRailDetector.field_176573_b));
        }
        for (Map.Entry entry : blockState.func_177228_b().entrySet()) {
            if (!(entry.getValue() instanceof BlockRailBase.EnumRailDirection)) continue;
            return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRailDirectionData.class, entry.getValue());
        }
        return null;
    }
}

