/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableComparatorData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePoweredData;
import org.spongepowered.api.data.type.ComparatorType;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeComparatorData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePoweredData;
import org.spongepowered.common.mixin.core.block.MixinBlock;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={BlockRedstoneComparator.class})
public abstract class MixinBlockRedstoneComparator
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.builder().addAll(super.getManipulators(blockState)).add((Object)this.getComparatorTypeFor(blockState)).add((Object)this.getIsPoweredFor(blockState)).build();
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return super.supports(immutable) || ImmutableComparatorData.class.isAssignableFrom(immutable) || ImmutablePoweredData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableComparatorData) {
            BlockRedstoneComparator.Mode comparatorType = (BlockRedstoneComparator.Mode)((ImmutableComparatorData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneComparator.field_176463_b, (Comparable)comparatorType));
        }
        if (manipulator instanceof ImmutablePoweredData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneComparator.field_176464_a, (Comparable)((ImmutablePoweredData)manipulator).powered().get()));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.COMPARATOR_TYPE)) {
            BlockRedstoneComparator.Mode comparatorType = (BlockRedstoneComparator.Mode)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneComparator.field_176463_b, (Comparable)comparatorType));
        }
        if (key.equals(Keys.POWERED)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneComparator.field_176464_a, (Comparable)((Boolean)value)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableComparatorData getComparatorTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeComparatorData.class, (ComparatorType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneComparator.field_176463_b)));
    }

    private ImmutablePoweredData getIsPoweredFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePoweredData.class, blockState.func_177229_b((IProperty)BlockRedstoneComparator.field_176464_a));
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation("item.comparator.name");
    }
}

