/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import java.util.Collections;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={BlockStaticLiquid.class})
public class MixinBlockStaticLiquid {
    @Redirect(method={"updateTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"))
    private boolean onSpreadFire(World world, BlockPos pos, IBlockState blockState) {
        if (!ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            if (!((IMixinWorld)world).isFake()) {
                return PhaseTracker.getInstance().setBlockState((IMixinWorldServer)world, pos, blockState, BlockChangeFlags.ALL);
            }
            return world.func_175656_a(pos, blockState);
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseContext<?> context = phaseTracker.getCurrentPhaseData().context;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(pos);
            frame.pushCause(this);
            context.getOwner().ifPresent(owner -> frame.addContext(EventContextKeys.OWNER, owner));
            context.getNotifier().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(frame.getCurrentCause(), Collections.singletonList(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, VecHelper.toVector3i(pos))));
            if (!SpongeImpl.postEvent(event)) {
                phaseTracker.setBlockState((IMixinWorldServer)world, pos, blockState, BlockChangeFlags.ALL);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

