/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import co.aikar.timings.SpongeTimings;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.TextComponentTranslation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.command.MinecraftCommandWrapper;
import org.spongepowered.common.interfaces.command.IMixinCommandBase;
import org.spongepowered.common.interfaces.command.IMixinCommandHandler;

@Mixin(value={CommandHandler.class})
public abstract class MixinCommandHandler
implements IMixinCommandHandler {
    private boolean expandedSelector;

    @Inject(method={"tryExecute"}, at={@At(value="HEAD")})
    public void onExecuteCommandHead(ICommandSender sender, String[] args, ICommand command, String input, CallbackInfoReturnable<Boolean> ci) {
        SpongeTimings.playerCommandTimer.startTimingIfSync();
        if (command instanceof IMixinCommandBase) {
            ((IMixinCommandBase)command).setExpandedSelector(this.isExpandedSelector());
        }
    }

    @Inject(method={"tryExecute"}, at={@At(value="RETURN")})
    public void onExecuteCommandReturn(ICommandSender sender, String[] args, ICommand command, String input, CallbackInfoReturnable<Boolean> ci) {
        SpongeTimings.playerCommandTimer.stopTimingIfSync();
        if (command instanceof IMixinCommandBase) {
            ((IMixinCommandBase)command).setExpandedSelector(false);
        }
    }

    @Inject(method={"tryExecute"}, at={@At(value="INVOKE", target="Lnet/minecraft/command/ICommandSender;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=2)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onCommandError(ICommandSender sender, String[] args, ICommand command, String input, CallbackInfoReturnable<Boolean> cir, TextComponentTranslation comp, Throwable error) {
        MinecraftCommandWrapper.setError(error);
        cir.setReturnValue(false);
    }

    @Surrogate
    public void onCommandError(ICommandSender sender, String[] args, ICommand command, String input, CallbackInfoReturnable<Boolean> cir, Throwable error, TextComponentTranslation comp) {
        MinecraftCommandWrapper.setError(error);
        cir.setReturnValue(false);
    }

    @Override
    public boolean isExpandedSelector() {
        return this.expandedSelector;
    }

    @Override
    public void setExpandedSelector(boolean expandedSelector) {
        this.expandedSelector = expandedSelector;
    }
}

