/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityCommandBlock;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.interfaces.command.IMixinCommandSourceName;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={EntityPlayerMP.class, TileEntityCommandBlock.class, EntityMinecartCommandBlock.class, MinecraftServer.class, RConConsoleSource.class}, targets={"net/minecraft/tileentity/TileEntitySign$1"})
public abstract class MixinCommandSource
implements IMixinCommandSourceName {
    private MessageChannel channel = MessageChannel.TO_ALL;

    @Override
    public void sendMessage(Text message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        this.asICommandSender().func_145747_a(SpongeTexts.toComponent(message));
    }

    @Override
    public MessageChannel getMessageChannel() {
        return this.channel;
    }

    @Override
    public void setMessageChannel(MessageChannel channel) {
        this.channel = (MessageChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
    }

    @Override
    public Optional<CommandSource> getCommandSource() {
        if (this instanceof User && !((User)((Object)this)).isOnline()) {
            return Optional.empty();
        }
        return Optional.of(this);
    }
}

