/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;

@Mixin(value={TileEntity.class, Entity.class, SpongeUser.class})
public abstract class MixinCustomDataHolder
implements IMixinCustomDataHolder {
    private List<DataManipulator<?, ?>> manipulators = Lists.newArrayList();
    private List<DataView> failedData = Lists.newArrayList();

    @Override
    public DataTransactionResult offerCustom(DataManipulator<?, ?> manipulator, MergeFunction function) {
        DataManipulator<?, ?> existingManipulator = null;
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!manipulator.getClass().isInstance(existing)) continue;
            existingManipulator = existing;
            break;
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        DataManipulator newManipulator = (DataManipulator)Preconditions.checkNotNull((Object)function.merge(existingManipulator, manipulator.copy()));
        if (existingManipulator != null) {
            builder.replace(existingManipulator.getValues());
            this.manipulators.remove(existingManipulator);
        }
        this.manipulators.add(newManipulator);
        return builder.success(newManipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getCustom(Class<T> customClass) {
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!customClass.isInstance(existing)) continue;
            return Optional.of(existing.copy());
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult removeCustom(Class<? extends DataManipulator<?, ?>> customClass) {
        DataManipulator<?, ?> manipulator = null;
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!customClass.isInstance(existing)) continue;
            manipulator = existing;
        }
        if (manipulator != null) {
            this.manipulators.remove(manipulator);
            this.removeCustomFromNbt(manipulator);
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public boolean hasManipulators() {
        return !this.manipulators.isEmpty();
    }

    @Override
    public boolean supportsCustom(Key<?> key) {
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().isPresent();
    }

    @Override
    public <E> Optional<E> getCustom(Key<? extends BaseValue<E>> key) {
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.get(key));
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getCustomValue(Key<V> key) {
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.getValue(key));
    }

    @Override
    public List<DataManipulator<?, ?>> getCustomManipulators() {
        return this.manipulators.stream().map(DataManipulator::copy).collect(Collectors.toList());
    }

    @Override
    public <E> DataTransactionResult offerCustom(Key<? extends BaseValue<E>> key, E value) {
        for (DataManipulator<? extends BaseValue<E>, ? extends BaseValue<E>> dataManipulator : this.manipulators) {
            if (!dataManipulator.supports(key)) continue;
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            builder.replace(((Value)dataManipulator.getValue(key).get()).asImmutable());
            dataManipulator.set(key, value);
            builder.success(((Value)dataManipulator.getValue(key).get()).asImmutable());
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult removeCustom(Key<?> key) {
        Iterator<DataManipulator<?, ?>> iterator = this.manipulators.iterator();
        while (iterator.hasNext()) {
            DataManipulator<?, ?> manipulator = iterator.next();
            if (manipulator.getKeys().size() != 1 || !manipulator.supports(key)) continue;
            iterator.remove();
            this.removeCustomFromNbt(manipulator);
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public void addFailedData(ImmutableList<DataView> failedData) {
        this.failedData.addAll((Collection<DataView>)failedData);
    }

    @Override
    public List<DataView> getFailedData() {
        return this.failedData;
    }
}

