/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.block.DirectionalData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.hanging.Hanging;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeDirectionalData;
import org.spongepowered.common.data.util.DirectionResolver;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.interfaces.entity.IMixinEntityHanging;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityHanging.class})
public abstract class MixinEntityHanging
extends MixinEntity
implements Hanging,
IMixinEntityHanging {
    @Shadow
    @Nullable
    public EnumFacing field_174860_b;
    @Shadow
    private int field_70520_f;
    private boolean ignorePhysics = false;

    @Shadow
    public abstract boolean func_70518_d();

    @Shadow
    public abstract void func_110128_b(Entity var1);

    @Shadow
    public abstract void func_174859_a(EnumFacing var1);

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityHanging;onValidSurface()Z"))
    private boolean checkIfOnValidSurfaceAndIgnoresPhysics(EntityHanging entityHanging) {
        return this.func_70518_d() && !this.ignorePhysics;
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74757_a("ignorePhysics", this.ignorePhysics);
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        if (compound.func_74764_b("ignorePhysics")) {
            this.ignorePhysics = compound.func_74767_n("ignorePhysics");
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityHanging;setDead()V")}, cancellable=true)
    private void onAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), new ArrayList(), this, 0, amount);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue(true);
            }
        }
    }

    @Override
    @Overwrite
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        double xOffset = (float)this.field_174860_b.func_82601_c() * 0.15f;
        double zOffset = (float)this.field_174860_b.func_82599_e() * 0.15f;
        if (((IMixinWorld)this.field_70170_p).isFake()) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + xOffset, this.field_70163_u + (double)offsetY, this.field_70161_v + zOffset, stack);
            entityitem.func_174869_p();
            this.field_70170_p.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return EntityUtil.entityOnDropItem((Entity)((EntityHanging)this), stack, offsetY, this.field_70165_t + xOffset, this.field_70161_v + zOffset);
    }

    @Override
    public Direction getDirection() {
        return this.field_174860_b == null ? Direction.NONE : DirectionResolver.getFor(this.field_174860_b);
    }

    @Override
    public void setDirection(Direction direction) {
        this.func_174859_a(DirectionResolver.getFor(direction));
    }

    @Override
    public DirectionalData getDirectionalData() {
        return new SpongeDirectionalData(this.getDirection());
    }

    @Override
    public Value<Direction> direction() {
        return new SpongeValue<Direction>(Keys.DIRECTION, this.getDirection());
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getDirectionalData());
    }
}

