/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.projectile.Firework;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.interfaces.entity.IMixinEntityFireworkRocket;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityFireworkRocket.class})
public abstract class MixinEntityFireworkRocket
extends MixinEntity
implements Firework,
IMixinEntityFireworkRocket {
    private static final String TARGET_ENTITY_STATE = "Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V";
    private static final int DEFAULT_EXPLOSION_RADIUS = 0;
    @Shadow
    private int field_92056_a;
    @Shadow
    private int field_92055_b;
    private ProjectileSource projectileSource = ProjectileSource.UNKNOWN;
    private int explosionRadius = 0;

    @Override
    public ProjectileSource getShooter() {
        return this.projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        this.projectileSource = shooter;
    }

    @Override
    public void setModifier(byte modifier) {
        this.field_92055_b = 10 * modifier + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, this);
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.projectileSource, null);
    }

    @Override
    public void detonate() {
        this.field_92056_a = this.field_92055_b + 1;
    }

    @Override
    public void prime() {
        Preconditions.checkState((!this.isPrimed() ? 1 : 0) != 0, (Object)"already primed");
        Preconditions.checkState((boolean)this.field_70128_L, (Object)"firework about to be primed");
        this.getWorld().spawnEntity(this);
    }

    @Override
    public void defuse() {
        Preconditions.checkState((boolean)this.isPrimed(), (Object)"not primed");
        if (this.shouldDefuse()) {
            this.func_70106_y();
            this.postDefuse();
        }
    }

    @Override
    public boolean isPrimed() {
        return this.field_92056_a > 0 && this.field_92056_a <= this.field_92055_b && !this.field_70128_L;
    }

    @Override
    public int getFuseDuration() {
        return this.field_92055_b;
    }

    @Override
    public void setFuseDuration(int fuseTicks) {
        this.field_92055_b = fuseTicks;
    }

    @Override
    public int getFuseTicksRemaining() {
        return this.field_92055_b - this.field_92056_a;
    }

    @Override
    public void setFuseTicksRemaining(int fuseTicks) {
        this.field_92056_a = 0;
        this.field_92055_b = fuseTicks;
    }

    @Override
    public Optional<Integer> getExplosionRadius() {
        return Optional.of(this.explosionRadius);
    }

    @Override
    public void setExplosionRadius(Optional<Integer> radius) {
        this.explosionRadius = radius.orElse(0);
    }

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V"))
    protected void onExplode(World world, Entity self, byte state) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.THROWER, this.getShooter());
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.getShooter());
            this.detonate(Explosion.builder().sourceExplosive(this).location(this.getLocation()).radius(this.explosionRadius)).ifPresent(explosion -> world.func_72960_a(self, state));
            frame.popCause();
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="RETURN")})
    protected void onUpdate(CallbackInfo ci) {
        if (this.field_92056_a == 1 && !this.field_70170_p.field_72995_K) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.THROWER, this.getShooter());
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.getShooter());
                this.postPrime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dealExplosionDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    public boolean useEntitySource(EntityLivingBase entityLivingBase, DamageSource source, float amount) {
        try {
            DamageSource.field_191552_t = new EntityDamageSource(DamageSource.field_191552_t.field_76373_n, (Entity)this).func_94540_d();
            boolean bl = entityLivingBase.func_70097_a(DamageSource.field_191552_t, amount);
            return bl;
        }
        finally {
            DamageSource.field_191552_t = source;
        }
    }
}

