/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.projectile.FishHook;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityFishHook.class})
public abstract class MixinEntityFishHook
extends MixinEntity
implements FishHook {
    @Shadow
    @Nullable
    private EntityPlayer field_146042_b;
    @Shadow
    @Nullable
    public Entity field_146043_c;
    @Shadow
    private int field_146045_ax;
    @Shadow
    private int field_191518_aw;
    @Shadow
    private boolean field_146051_au;
    @Nullable
    private ProjectileSource projectileSource;

    @Shadow
    protected abstract void func_184527_k();

    @Override
    public ProjectileSource getShooter() {
        if (this.projectileSource != null) {
            return this.projectileSource;
        }
        if (this.field_146042_b != null && this.field_146042_b instanceof ProjectileSource) {
            return (ProjectileSource)this.field_146042_b;
        }
        return ProjectileSource.UNKNOWN;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        this.field_146042_b = shooter instanceof EntityPlayer ? (EntityPlayer)shooter : null;
        this.projectileSource = shooter;
    }

    @Override
    public Optional<org.spongepowered.api.entity.Entity> getHookedEntity() {
        return Optional.ofNullable((org.spongepowered.api.entity.Entity)this.field_146043_c);
    }

    @Override
    public void setHookedEntity(@Nullable org.spongepowered.api.entity.Entity entity) {
        this.field_146043_c = (Entity)entity;
    }

    @Inject(method={"setHookedEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetHookedEntity(CallbackInfo ci) {
        if (SpongeImpl.postEvent(SpongeEventFactory.createFishingEventHookEntity(Sponge.getCauseStackManager().getCurrentCause(), this, (org.spongepowered.api.entity.Entity)this.field_146043_c))) {
            this.field_146043_c = null;
            ci.cancel();
        }
    }

    @Overwrite
    public int func_146034_e() {
        if (!this.field_70170_p.field_72995_K && this.field_146042_b != null) {
            List<Object> transactions;
            int i = 0;
            if (this.field_146045_ax > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p);
                lootcontext$builder.func_186469_a((float)this.field_191518_aw + this.field_146042_b.func_184817_da());
                transactions = this.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a()).stream().map(s -> {
                    ItemStackSnapshot snapshot = ((ItemStack)s).createSnapshot();
                    return new Transaction<ItemStackSnapshot>(snapshot, snapshot);
                }).collect(Collectors.toList());
            } else {
                transactions = new ArrayList();
            }
            Sponge.getCauseStackManager().pushCause(this.field_146042_b);
            if (SpongeImpl.postEvent(SpongeEventFactory.createFishingEventStop(Sponge.getCauseStackManager().getCurrentCause(), this, transactions))) {
                return -1;
            }
            if (this.field_146043_c != null) {
                this.func_184527_k();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                int n = i = this.field_146043_c instanceof EntityItem ? 3 : 5;
            }
            if (!transactions.isEmpty()) {
                for (Transaction transaction : transactions) {
                    if (!transaction.isValid()) continue;
                    net.minecraft.item.ItemStack itemstack = (net.minecraft.item.ItemStack)((ItemStackSnapshot)transaction.getFinal()).createStack();
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                    double d0 = this.field_146042_b.field_70165_t - this.field_70165_t;
                    double d1 = this.field_146042_b.field_70163_u - this.field_70163_u;
                    double d2 = this.field_146042_b.field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    entityitem.field_70159_w = d0 * 0.1;
                    entityitem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * 0.1;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                    this.field_146042_b.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_146042_b.field_70170_p, this.field_146042_b.field_70165_t, this.field_146042_b.field_70163_u + 0.5, this.field_146042_b.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    Item item = itemstack.func_77973_b();
                    if (item != Items.field_151115_aP && item != Items.field_179566_aV) continue;
                    this.field_146042_b.func_71064_a(StatList.field_188071_E, 1);
                }
                Sponge.getCauseStackManager().popCause();
                i = Math.max(i, 1);
            }
            if (this.field_146051_au) {
                i = 2;
            }
            this.func_70106_y();
            return i;
        }
        return 0;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, this);
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.getShooter(), (Entity)this.field_146042_b);
    }
}

