/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntityLockable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.EmptyInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.entity.player.SpongeUserInventory;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.SlotCollectionIterator;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;

@Mixin(value={net.minecraft.inventory.Slot.class, Container.class, InventoryPlayer.class, EntityVillager.class, InventoryLargeChest.class, TileEntityLockable.class, CustomInventory.class, InventoryBasic.class, SpongeUserInventory.class, InventoryCrafting.class, InventoryCraftResult.class, EntityMinecartContainer.class}, priority=999)
@Implements(value={@Interface(iface=Inventory.class, prefix="inventory$")})
public abstract class MixinTraitInventory
implements MinecraftInventoryAdapter {
    protected EmptyInventory empty;
    @Nullable
    protected Inventory parent;
    protected Inventory next;
    protected List<Inventory> children = new ArrayList<Inventory>();
    protected Iterable<Slot> slotIterator;
    private PluginContainer plugin = null;
    protected Fabric fabric;

    @Override
    public Inventory parent() {
        return this.parent == null ? this : this.parent();
    }

    @Override
    public Inventory root() {
        return this.parent() == this ? this : this.parent().root();
    }

    @Override
    public <T extends Inventory> T first() {
        return (T)this.iterator().next();
    }

    @Override
    public <T extends Inventory> T next() {
        return (T)this.emptyInventory();
    }

    @Override
    public Inventory getChild(int index) {
        if (index < 0 || index >= this.getRootLens().getChildren().size()) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        while (index >= this.children.size()) {
            this.children.add(null);
        }
        Inventory child = this.children.get(index);
        if (child == null) {
            child = this.getRootLens().getChildren().get(index).getAdapter(this.getFabric(), this);
            this.children.set(index, child);
        }
        return child;
    }

    protected final EmptyInventory emptyInventory() {
        if (this.empty == null) {
            this.empty = new EmptyInventoryImpl(this);
        }
        return this.empty;
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        if (this.slotIterator == null) {
            this.slotIterator = new SlotCollectionIterator(this, this.getFabric(), this.getRootLens(), this.getSlotProvider());
        }
        return this.slotIterator;
    }

    @Intrinsic
    public void inventory$clear() {
        this.getFabric().clear();
    }

    @Override
    public Fabric getFabric() {
        if (this.fabric == null) {
            this.fabric = MinecraftFabric.of(this);
        }
        return this.fabric;
    }

    @Override
    public PluginContainer getPlugin() {
        if (this.plugin == null) {
            PluginContainer container;
            String id;
            Optional carrier;
            MixinTraitInventory base = this;
            if (base instanceof CarriedInventory && (carrier = ((CarriedInventory)((Object)base)).getCarrier()).isPresent()) {
                base = carrier.get();
            }
            if (base instanceof TileEntity) {
                id = ((TileEntity)((Object)base)).getBlock().getType().getId();
                String pluginId = id.substring(0, id.indexOf(":"));
                container = Sponge.getPluginManager().getPlugin(pluginId).orElseThrow(() -> new AssertionError((Object)("Missing plugin " + pluginId + " for block " + id)));
            } else if (base instanceof Entity) {
                id = ((Entity)((Object)base)).getType().getId();
                String pluginId = id.substring(0, id.indexOf(":"));
                container = Sponge.getPluginManager().getPlugin(pluginId).orElseThrow(() -> new AssertionError((Object)("Missing plugin " + pluginId + " for entity " + id + " (" + this.getClass().getName() + ")")));
            } else {
                container = base instanceof SpongeUser ? SpongeImpl.getMinecraftPlugin() : Sponge.getPluginManager().getPlugin(SpongeImplHooks.getModIdFromClass(this.getClass())).orElseGet(() -> {
                    SpongeImpl.getLogger().warn("Unknown plugin for " + this);
                    return SpongeImpl.getMinecraftPlugin();
                });
            }
            this.plugin = container;
        }
        return this.plugin;
    }
}

