/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.biome;

import java.util.Iterator;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeTaiga;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.type.DoublePlantTypes;
import org.spongepowered.api.data.type.ShrubTypes;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.world.biome.GroundCoverLayer;
import org.spongepowered.api.world.gen.populator.BlockBlob;
import org.spongepowered.api.world.gen.populator.DoublePlant;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.populator.Shrub;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.mixin.core.world.biome.MixinBiome;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.gen.WorldGenConstants;

@Mixin(value={BiomeTaiga.class})
public abstract class MixinBiomeTaiga
extends MixinBiome {
    @Shadow
    @Final
    private BiomeTaiga.Type field_150644_aH;

    @Override
    public void buildPopulators(World world, SpongeBiomeGenerationSettings gensettings) {
        if (this.field_150644_aH == BiomeTaiga.Type.MEGA || this.field_150644_aH == BiomeTaiga.Type.MEGA_SPRUCE) {
            BlockBlob blob = BlockBlob.builder().blobCount(VariableAmount.baseWithRandomAddition(0.0, 3.0)).block((BlockState)Blocks.field_150341_Y.func_176223_P()).radius(VariableAmount.baseWithRandomAddition(0.0, 2.0)).build();
            gensettings.getPopulators().add(blob);
        }
        DoublePlant fern = DoublePlant.builder().type(DoublePlantTypes.FERN, 1.0).perChunk(35).build();
        gensettings.getPopulators().add(fern);
        super.buildPopulators(world, gensettings);
        if (this.field_150644_aH == BiomeTaiga.Type.MEGA || this.field_150644_aH == BiomeTaiga.Type.MEGA_SPRUCE) {
            gensettings.getGroundCoverLayers().clear();
            gensettings.getGroundCoverLayers().add(new GroundCoverLayer(seed -> {
                if (seed > 1.75) {
                    return (BlockState)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
                }
                if (seed > -0.95) {
                    return (BlockState)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
                }
                return (BlockState)Blocks.field_150349_c.func_176223_P();
            }, WorldGenConstants.GROUND_COVER_DEPTH));
            gensettings.getGroundCoverLayers().add(new GroundCoverLayer((BlockState)this.field_76753_B, WorldGenConstants.GROUND_COVER_DEPTH));
        }
        BiomeDecorator theBiomeDecorator = this.field_76760_I;
        Iterator<Shrub> it = gensettings.getPopulators(Shrub.class).iterator();
        while (it.hasNext()) {
            TableEntry entry;
            Shrub next = it.next();
            if (next.getTypes().size() != 1 || !((entry = next.getTypes().getEntries().get(0)) instanceof WeightedObject) || ((WeightedObject)entry).get() != ShrubTypes.TALL_GRASS) continue;
            it.remove();
        }
        Shrub grass = Shrub.builder().perChunk(theBiomeDecorator.field_76803_B * 128).type(ShrubTypes.FERN, 4).type(ShrubTypes.TALL_GRASS, 1).build();
        gensettings.getPopulators().add(grass);
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)theBiomeDecorator.field_76832_z, 1.0, 0.1));
        if (this.field_150644_aH == BiomeTaiga.Type.MEGA || this.field_150644_aH == BiomeTaiga.Type.MEGA_SPRUCE) {
            if (this.field_150644_aH == BiomeTaiga.Type.MEGA) {
                forest.type(BiomeTreeTypes.POINTY_TAIGA.getLargePopulatorObject().get(), 1.0);
                forest.type(BiomeTreeTypes.TALL_TAIGA.getLargePopulatorObject().get(), 12.0);
            } else {
                forest.type(BiomeTreeTypes.TALL_TAIGA.getLargePopulatorObject().get(), 13.0);
            }
            forest.type(BiomeTreeTypes.POINTY_TAIGA.getPopulatorObject(), 8.666666666666666);
            forest.type(BiomeTreeTypes.TALL_TAIGA.getPopulatorObject(), 17.333333333333332);
        } else {
            forest.type(BiomeTreeTypes.POINTY_TAIGA.getPopulatorObject(), 1.0);
            forest.type(BiomeTreeTypes.TALL_TAIGA.getPopulatorObject(), 2.0);
        }
        gensettings.getPopulators().add(0, forest.build());
    }
}

