/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenLakes;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.property.block.MatterProperty;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Lake;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenLakes.class})
public abstract class MixinWorldGenLake
implements Lake {
    private double prob;
    private VariableAmount height;
    @Shadow
    @Final
    @Mutable
    private Block field_150556_a;

    @Shadow
    public abstract boolean func_180709_b(World var1, Random var2, BlockPos var3);

    @Inject(method={"<init>(Lnet/minecraft/block/Block;)V"}, at={@At(value="RETURN")})
    public void onConstructed(Block block, CallbackInfo ci) {
        this.prob = 0.25;
        this.height = VariableAmount.baseWithRandomAddition(0.0, 256.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.LAKE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        if (random.nextDouble() < this.prob) {
            int x = random.nextInt(size.getX());
            int y = this.height.getFlooredAmount(random);
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, new BlockPos(x + min.getX(), y + min.getY(), z + min.getZ()));
        }
    }

    @Override
    public BlockState getLiquidType() {
        return (BlockState)this.field_150556_a.func_176223_P();
    }

    @Override
    public void setLiquidType(BlockState liquid) {
        Preconditions.checkNotNull((Object)liquid, (Object)"Must provide a non-null BlockState!");
        Optional<MatterProperty> matter = liquid.getType().getProperty(MatterProperty.class);
        Preconditions.checkArgument((boolean)matter.isPresent(), (Object)"For some reason, the property is not returning correctly!");
        Preconditions.checkArgument((matter.get().getValue() == MatterProperty.Matter.LIQUID ? 1 : 0) != 0, (Object)"Must use a liquid property based BlockState!");
        this.field_150556_a = (Block)liquid.getType();
    }

    @Override
    public double getLakeProbability() {
        return this.prob;
    }

    @Override
    public void setLakeProbability(double p) {
        this.prob = p;
    }

    @Override
    public VariableAmount getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(VariableAmount height) {
        this.height = height;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Type", (Object)"Lake").add("Chance", this.prob).add("Height", (Object)this.height).add("LiquidType", (Object)this.field_150556_a).toString();
    }
}

