/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.IModData_Collisions;

@Mixin(value={Chunk.class})
public class MixinChunk_Collisions {
    @Shadow
    @Final
    private World field_76637_e;

    @Inject(method={"getEntitiesWithinAABBForEntity"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    public void onAddCollisionEntity(Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> predicate, CallbackInfo ci) {
        if (this.field_76637_e.field_72995_K || entityIn == null || entityIn instanceof EntityPlayer || entityIn.func_70021_al() != null) {
            return;
        }
        if (entityIn != null && entityIn instanceof EntityLivingBase && ((IModData_Collisions)entityIn).isRunningCollideWithNearby()) {
            return;
        }
        if (!this.allowEntityCollision(listToFill)) {
            ci.cancel();
        }
    }

    @Inject(method={"getEntitiesOfTypeWithinAABB"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    public <T extends Entity> void onAddCollisionEntity(Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> p_177430_4_, CallbackInfo ci) {
        if (this.field_76637_e.field_72995_K || EntityPlayer.class.isAssignableFrom(entityClass) || EntityItem.class == entityClass) {
            return;
        }
        if (!this.allowEntityCollision(listToFill)) {
            ci.cancel();
        }
    }

    private <T extends Entity> boolean allowEntityCollision(List<T> listToFill) {
        if (this.field_76637_e instanceof IMixinWorldServer) {
            if (PhaseTracker.getInstance().getCurrentState().ignoresEntityCollisions()) {
                return true;
            }
            PhaseContext<?> phaseContext = PhaseTracker.getInstance().getCurrentContext();
            Object source = phaseContext.getSource();
            if (source == null) {
                return true;
            }
            if (source instanceof LocatableBlock) {
                LocatableBlock locatable = (LocatableBlock)source;
                BlockType blockType = locatable.getLocation().getBlockType();
                IModData_Collisions spongeBlock = (IModData_Collisions)((Object)blockType);
                if (spongeBlock.requiresCollisionsCacheRefresh()) {
                    spongeBlock.initializeCollisionState(this.field_76637_e);
                    spongeBlock.requiresCollisionsCacheRefresh(false);
                }
                return spongeBlock.getMaxCollisions() < 0 || listToFill.size() < spongeBlock.getMaxCollisions();
            }
            if (source instanceof IModData_Collisions) {
                IModData_Collisions spongeEntity = (IModData_Collisions)source;
                if (spongeEntity.requiresCollisionsCacheRefresh()) {
                    spongeEntity.initializeCollisionState(this.field_76637_e);
                    spongeEntity.requiresCollisionsCacheRefresh(false);
                }
                return spongeEntity.getMaxCollisions() < 0 || listToFill.size() < spongeEntity.getMaxCollisions();
            }
            return true;
        }
        return true;
    }
}

