/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.world;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.util.math.IMixinBlockPos;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.mixin.core.world.MixinWorld;

@Mixin(value={WorldServer.class})
public abstract class MixinWorldServer_Async_Lighting
extends MixinWorld
implements IMixinWorldServer {
    private static final int NUM_XZ_BITS = 4;
    private static final int NUM_SHORT_Y_BITS = 8;
    private static final short XZ_MASK = 15;
    private static final short Y_SHORT_MASK = 255;
    private ExecutorService lightExecutorService = Executors.newFixedThreadPool(SpongeImpl.getGlobalConfig().getConfig().getOptimizations().getAsyncLightingCategory().getNumThreads(), new ThreadFactoryBuilder().setNameFormat("Sponge - Async Light Thread").build());

    @Override
    public boolean func_180500_c(EnumSkyBlock lightType, BlockPos pos) {
        return this.updateLightAsync(lightType, pos, null);
    }

    @Override
    public boolean checkLightAsync(EnumSkyBlock lightType, BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        IMixinChunk spongeChunk = (IMixinChunk)currentChunk;
        int i = 0;
        int j = 0;
        int k = this.getLightForAsync(lightType, pos, currentChunk, neighbors);
        int l = this.getRawBlockLightAsync(lightType, pos, currentChunk, neighbors);
        int i1 = pos.func_177958_n();
        int j1 = pos.func_177956_o();
        int k1 = pos.func_177952_p();
        if (l > k) {
            this.field_72994_J[j++] = 133152;
        } else if (l < k) {
            this.field_72994_J[j++] = 0x20820 | k << 18;
            while (i < j) {
                int l3;
                int k3;
                int j3;
                int l1 = this.field_72994_J[i++];
                int i2 = (l1 & 0x3F) - 32 + i1;
                int j2 = (l1 >> 6 & 0x3F) - 32 + j1;
                int k2 = (l1 >> 12 & 0x3F) - 32 + k1;
                int l2 = l1 >> 18 & 0xF;
                BlockPos blockpos = new BlockPos(i2, j2, k2);
                int i3 = this.getLightForAsync(lightType, blockpos, currentChunk, neighbors);
                if (i3 != l2) continue;
                this.setLightForAsync(lightType, blockpos, 0, currentChunk, neighbors);
                if (l2 <= 0 || (j3 = MathHelper.func_76130_a((int)(i2 - i1))) + (k3 = MathHelper.func_76130_a((int)(j2 - j1))) + (l3 = MathHelper.func_76130_a((int)(k2 - k1))) >= 17) continue;
                BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int i4 = i2 + enumfacing.func_82601_c();
                    int j4 = j2 + enumfacing.func_96559_d();
                    int k4 = k2 + enumfacing.func_82599_e();
                    blockpos$pooledmutableblockpos.func_181079_c(i4, j4, k4);
                    Chunk pooledChunk = this.getLightChunk((BlockPos)blockpos$pooledmutableblockpos, currentChunk, neighbors);
                    if (pooledChunk == null) continue;
                    int l4 = Math.max(1, pooledChunk.func_177435_g((BlockPos)blockpos$pooledmutableblockpos).func_185891_c());
                    i3 = this.getLightForAsync(lightType, (BlockPos)blockpos$pooledmutableblockpos, currentChunk, neighbors);
                    if (i3 != l2 - l4 || j >= this.field_72994_J.length) continue;
                    this.field_72994_J[j++] = i4 - i1 + 32 | j4 - j1 + 32 << 6 | k4 - k1 + 32 << 12 | l2 - l4 << 18;
                }
                blockpos$pooledmutableblockpos.func_185344_t();
            }
            i = 0;
        }
        while (i < j) {
            boolean flag;
            int i5 = this.field_72994_J[i++];
            int j5 = (i5 & 0x3F) - 32 + i1;
            int k5 = (i5 >> 6 & 0x3F) - 32 + j1;
            int l5 = (i5 >> 12 & 0x3F) - 32 + k1;
            BlockPos blockpos1 = new BlockPos(j5, k5, l5);
            int i6 = this.getLightForAsync(lightType, blockpos1, currentChunk, neighbors);
            int j6 = this.getRawBlockLightAsync(lightType, blockpos1, currentChunk, neighbors);
            if (j6 == i6) continue;
            this.setLightForAsync(lightType, blockpos1, j6, currentChunk, neighbors);
            if (j6 <= i6) continue;
            int k6 = Math.abs(j5 - i1);
            int l6 = Math.abs(k5 - j1);
            int i7 = Math.abs(l5 - k1);
            boolean bl = flag = j < this.field_72994_J.length - 6;
            if (k6 + l6 + i7 >= 17 || !flag) continue;
            if (this.getLightForAsync(lightType, blockpos1.func_177976_e(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightForAsync(lightType, blockpos1.func_177974_f(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 + 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightForAsync(lightType, blockpos1.func_177977_b(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightForAsync(lightType, blockpos1.func_177984_a(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 + 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightForAsync(lightType, blockpos1.func_177978_c(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - 1 - k1 + 32 << 12);
            }
            if (this.getLightForAsync(lightType, blockpos1.func_177968_d(), currentChunk, neighbors) >= j6) continue;
            this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 + 1 - k1 + 32 << 12);
        }
        spongeChunk.getQueuedLightingUpdates(lightType).remove((Object)this.blockPosToShort(pos));
        spongeChunk.getPendingLightUpdates().decrementAndGet();
        for (Chunk neighborChunk : neighbors) {
            IMixinChunk neighbor = (IMixinChunk)neighborChunk;
            neighbor.getPendingLightUpdates().decrementAndGet();
        }
        return true;
    }

    @Override
    public boolean updateLightAsync(EnumSkyBlock lightType, BlockPos pos, @Nullable Chunk currentChunk) {
        if (this.func_73046_m().func_71241_aa() || this.lightExecutorService.isShutdown()) {
            return false;
        }
        if (currentChunk == null) {
            currentChunk = ((IMixinChunkProviderServer)this.field_73020_y).getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        }
        IMixinChunk spongeChunk = (IMixinChunk)currentChunk;
        if (currentChunk == null || currentChunk.field_189550_d || !spongeChunk.areNeighborsLoaded()) {
            return false;
        }
        short shortPos = this.blockPosToShort(pos);
        if (spongeChunk.getQueuedLightingUpdates(lightType).contains(shortPos)) {
            return false;
        }
        Chunk chunk = currentChunk;
        spongeChunk.getQueuedLightingUpdates(lightType).add(shortPos);
        spongeChunk.getPendingLightUpdates().incrementAndGet();
        spongeChunk.setLightUpdateTime(chunk.func_177412_p().func_82737_E());
        List<Chunk> neighbors = spongeChunk.getNeighbors();
        Chunk southEastChunk = ((IMixinChunk)spongeChunk.getNeighborChunk(0)).getNeighborChunk(2);
        Chunk southWestChunk = ((IMixinChunk)spongeChunk.getNeighborChunk(0)).getNeighborChunk(3);
        Chunk northEastChunk = ((IMixinChunk)spongeChunk.getNeighborChunk(1)).getNeighborChunk(2);
        Chunk northWestChunk = ((IMixinChunk)spongeChunk.getNeighborChunk(1)).getNeighborChunk(3);
        if (southEastChunk != null) {
            neighbors.add(southEastChunk);
        }
        if (southWestChunk != null) {
            neighbors.add(southWestChunk);
        }
        if (northEastChunk != null) {
            neighbors.add(northEastChunk);
        }
        if (northWestChunk != null) {
            neighbors.add(northWestChunk);
        }
        for (Chunk neighborChunk : neighbors) {
            IMixinChunk neighbor = (IMixinChunk)neighborChunk;
            neighbor.getPendingLightUpdates().incrementAndGet();
            neighbor.setLightUpdateTime(chunk.func_177412_p().func_82737_E());
        }
        if (SpongeImpl.getServer().func_152345_ab()) {
            this.lightExecutorService.execute(() -> this.checkLightAsync(lightType, pos, chunk, neighbors));
        } else {
            this.checkLightAsync(lightType, pos, chunk, neighbors);
        }
        return true;
    }

    @Override
    public ExecutorService getLightingExecutor() {
        return this.lightExecutorService;
    }

    public Chunk getLightChunk(BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        if (currentChunk.func_76600_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            if (currentChunk.field_189550_d) {
                return null;
            }
            return currentChunk;
        }
        for (Chunk neighbor : neighbors) {
            if (!neighbor.func_76600_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
            if (neighbor.field_189550_d) {
                return null;
            }
            return neighbor;
        }
        return null;
    }

    private int getLightForAsync(EnumSkyBlock lightType, BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!((IMixinBlockPos)pos).isValidPosition()) {
            return lightType.field_77198_c;
        }
        Chunk chunk = this.getLightChunk(pos, currentChunk, neighbors);
        if (chunk == null || chunk.field_189550_d) {
            return lightType.field_77198_c;
        }
        return chunk.func_177413_a(lightType, pos);
    }

    private int getRawBlockLightAsync(EnumSkyBlock lightType, BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        Chunk chunk = this.getLightChunk(pos, currentChunk, neighbors);
        if (chunk == null || chunk.field_189550_d) {
            return lightType.field_77198_c;
        }
        if (lightType == EnumSkyBlock.SKY && chunk.func_177444_d(pos)) {
            return 15;
        }
        IBlockState blockState = chunk.func_177435_g(pos);
        int blockLight = SpongeImplHooks.getChunkPosLight(blockState, (World)this, pos);
        int i = lightType == EnumSkyBlock.SKY ? 0 : blockLight;
        int j = SpongeImplHooks.getBlockLightOpacity(blockState, (IBlockAccess)((World)this), pos);
        if (j >= 15 && blockLight > 0) {
            j = 1;
        }
        if (j < 1) {
            j = 1;
        }
        if (j >= 15) {
            return 0;
        }
        if (i >= 14) {
            return i;
        }
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            int k = this.getLightForAsync(lightType, blockpos, currentChunk, neighbors) - j;
            if (k > i) {
                i = k;
            }
            if (i < 14) continue;
            return i;
        }
        return i;
    }

    public void setLightForAsync(EnumSkyBlock type, BlockPos pos, int lightValue, Chunk currentChunk, List<Chunk> neighbors) {
        Chunk chunk;
        if (((IMixinBlockPos)pos).isValidPosition() && (chunk = this.getLightChunk(pos, currentChunk, neighbors)) != null && !chunk.field_189550_d) {
            chunk.func_177431_a(type, pos, lightValue);
            this.func_175679_n(pos);
        }
    }

    private short blockPosToShort(BlockPos pos) {
        short serialized = (short)this.setNibble(0, pos.func_177958_n() & 0xF, 0, 4);
        serialized = (short)this.setNibble(serialized, pos.func_177956_o() & 0xFF, 1, 8);
        serialized = (short)this.setNibble(serialized, pos.func_177952_p() & 0xF, 3, 4);
        return serialized;
    }

    private int setNibble(int num, int data, int which, int bitsToReplace) {
        return num & ~(bitsToReplace << which * 4) | data << which * 4;
    }
}

