/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketPlayer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class PacketUtil {
    public static void onProcessPacket(Packet packetIn, INetHandler netHandler) {
        if (netHandler instanceof NetHandlerPlayServer) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                EntityPlayerMP packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
                frame.pushCause(packetPlayer);
                if (PacketUtil.creativeExploitCheck(packetIn, packetPlayer)) {
                    return;
                }
                boolean ignoreMovementCapture = false;
                if (packetIn instanceof CPacketPlayer) {
                    CPacketPlayer movingPacket = (CPacketPlayer)packetIn;
                    if (movingPacket instanceof CPacketPlayer.Rotation) {
                        ignoreMovementCapture = true;
                    } else if (packetPlayer.field_70165_t == movingPacket.field_149479_a && packetPlayer.field_70163_u == movingPacket.field_149477_b && packetPlayer.field_70161_v == movingPacket.field_149478_c) {
                        ignoreMovementCapture = true;
                    }
                }
                if (ignoreMovementCapture || packetIn instanceof CPacketClientSettings) {
                    packetIn.func_148833_a(netHandler);
                }
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(packetPlayer.field_71071_by.func_70445_o());
                IPhaseState<PacketContext<?>> packetState = TrackingPhases.PACKET.getStateForPacket(packetIn);
                if (packetState == null) {
                    throw new IllegalArgumentException("Found a null packet phase for packet: " + packetIn.getClass());
                }
                BasicPacketContext context = PacketPhase.General.UNKNOWN.createPhaseContext();
                if (!TrackingPhases.PACKET.isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    context = ((PacketContext)((PacketContext)((PacketContext)packetState.createPhaseContext().source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn)).cursor(cursor);
                    TrackingPhases.PACKET.populateContext(packetIn, packetPlayer, packetState, context);
                    context.owner((Player)packetPlayer);
                    context.notifier((Player)packetPlayer);
                }
                try (BasicPacketContext packetContext = context;){
                    packetContext.buildAndSwitch();
                    packetIn.func_148833_a(netHandler);
                }
                if (packetIn instanceof CPacketClientStatus) {
                    packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
                }
                ((IMixinEntityPlayerMP)packetPlayer).setPacketItem(ItemStack.field_190927_a);
            }
        } else {
            packetIn.func_148833_a(netHandler);
        }
    }

    private static boolean creativeExploitCheck(Packet<?> packetIn, EntityPlayerMP playerMP) {
        return false;
    }
}

