/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.effect.potion.PotionEffectTypes;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class PotionEffectTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<PotionEffectType>,
AlternateCatalogRegistryModule<PotionEffectType> {
    private final List<PotionEffectType> potionList = new ArrayList<PotionEffectType>();
    @RegisterCatalog(value=PotionEffectTypes.class)
    private final Map<String, PotionEffectType> potionEffectTypeMap = new HashMap<String, PotionEffectType>();

    public static PotionEffectTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, PotionEffectType> provideCatalogMap() {
        HashMap<String, PotionEffectType> potionEffectTypeMap = new HashMap<String, PotionEffectType>();
        for (Map.Entry<String, PotionEffectType> entry : this.potionEffectTypeMap.entrySet()) {
            potionEffectTypeMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return potionEffectTypeMap;
    }

    @Override
    public Optional<PotionEffectType> getById(String id) {
        if (!((String)Preconditions.checkNotNull((Object)id)).contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.potionEffectTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<PotionEffectType> getAll() {
        return ImmutableList.copyOf(this.potionList);
    }

    @Override
    public void registerDefaults() {
        for (Potion potion : Potion.field_188414_b) {
            if (potion == null) continue;
            PotionEffectType potionEffectType = (PotionEffectType)potion;
            this.potionList.add(potionEffectType);
            this.potionEffectTypeMap.put(((ResourceLocation)Potion.field_188414_b.func_177774_c((Object)potion)).toString(), potionEffectType);
        }
    }

    @AdditionalRegistration
    public void additionalRegistration() {
        for (Potion potion : Potion.field_188414_b) {
            PotionEffectType potionEffectType;
            if (potion == null || this.potionList.contains(potionEffectType = (PotionEffectType)potion)) continue;
            this.potionList.add(potionEffectType);
            this.potionEffectTypeMap.put(((ResourceLocation)Potion.field_188414_b.func_177774_c((Object)potion)).toString(), potionEffectType);
        }
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(PotionEffectType extraCatalog) {
    }

    public void registerFromGameData(String id, PotionEffectType itemType) {
        this.potionEffectTypeMap.put(id.toLowerCase(Locale.ENGLISH), itemType);
    }

    PotionEffectTypeRegistryModule() {
    }

    private static final class Holder {
        static final PotionEffectTypeRegistryModule INSTANCE = new PotionEffectTypeRegistryModule();

        private Holder() {
        }
    }
}

