/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.DamageableData;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackComparators;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.DelayedRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class ItemStackComparatorRegistryModule
implements RegistryModule {
    @RegisterCatalog(value=ItemStackComparators.class)
    private final Map<String, Comparator<ItemStack>> comparators = new HashMap<String, Comparator<ItemStack>>();

    @Override
    @DelayedRegistration(value=RegistrationPhase.PRE_INIT)
    public void registerDefaults() {
        Comparator<ItemStack> type = Comparator.comparing(i -> i.getType().getId());
        this.comparators.put("type", type);
        Comparator<ItemStack> size = Comparator.comparing(ItemStack::getQuantity);
        this.comparators.put("size", size);
        Comparator<ItemStack> typeSize = type.thenComparing(size);
        this.comparators.put("type_size", typeSize);
        this.comparators.put("default", typeSize);
        Properties properties = new Properties();
        this.comparators.put("properties", properties);
        ItemDataComparator itemData = new ItemDataComparator(new Class[0]);
        this.comparators.put("item_data", itemData);
        this.comparators.put("item_data_ignore_damage", new ItemDataComparator(DamageableData.class));
        this.comparators.put("ignore_size", type.thenComparing(properties).thenComparing(itemData));
        this.comparators.put("all", type.thenComparing(size).thenComparing(properties).thenComparing(itemData));
    }

    private static final class ItemDataComparator
    implements Comparator<ItemStack> {
        private final Class<? extends DataManipulator<?, ?>>[] ignored;

        ItemDataComparator(Class<? extends DataManipulator<?, ?>> ... ignored) {
            this.ignored = ignored;
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            LinkedHashSet manipulators = new LinkedHashSet(o2.getContainers());
            for (DataManipulator manipulator : o1.getContainers()) {
                if (manipulators.contains(manipulator)) {
                    manipulators.remove(manipulator);
                    continue;
                }
                if (this.isIgnored(manipulators, manipulator)) continue;
                return -1;
            }
            return manipulators.size();
        }

        private boolean isIgnored(Set<DataManipulator<?, ?>> list, DataManipulator<?, ?> toCheck) {
            for (Class<DataManipulator<?, ?>> clazz : this.ignored) {
                if (!clazz.isAssignableFrom(toCheck.getClass())) continue;
                list.removeIf(manip -> ignore.isAssignableFrom(manip.getClass()));
                return true;
            }
            return false;
        }
    }

    private static final class Properties
    implements Comparator<ItemStack> {
        private Properties() {
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            HashSet properties = new HashSet(o2.getApplicableProperties());
            for (Property<?, ?> property : o1.getApplicableProperties()) {
                if (properties.contains(property)) {
                    properties.remove(property);
                    continue;
                }
                return -1;
            }
            return properties.size();
        }
    }
}

