/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.WorldType;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;
import org.spongepowered.common.world.type.SpongeWorldTypeEnd;
import org.spongepowered.common.world.type.SpongeWorldTypeNether;
import org.spongepowered.common.world.type.SpongeWorldTypeOverworld;

@RegisterCatalog(value=GeneratorTypes.class)
public final class GeneratorTypeRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<GeneratorType>
implements SpongeAdditionalCatalogRegistryModule<GeneratorType>,
AlternateCatalogRegistryModule<GeneratorType> {
    public static GeneratorTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        for (WorldType worldType : WorldType.field_77139_a) {
            this.registerAdditionalCatalog((GeneratorType)worldType);
        }
        this.registerAdditionalCatalog((GeneratorType)((Object)new SpongeWorldTypeEnd()));
        this.registerAdditionalCatalog((GeneratorType)((Object)new SpongeWorldTypeNether()));
        this.registerAdditionalCatalog((GeneratorType)((Object)new SpongeWorldTypeOverworld()));
    }

    @AdditionalRegistration(value=RegistrationPhase.PRE_REGISTRY)
    public void registerAdditional() {
        for (WorldType worldType : WorldType.field_77139_a) {
            if (worldType == null || this.catalogTypeMap.values().contains(worldType)) continue;
            this.catalogTypeMap.put(worldType.func_77127_a().toLowerCase(Locale.ENGLISH), (GeneratorType)worldType);
        }
        RegistryHelper.mapFields(GeneratorTypes.class, this.provideCatalogMap());
    }

    @Override
    public Map<String, GeneratorType> provideCatalogMap() {
        HashMap<String, GeneratorType> map = new HashMap<String, GeneratorType>();
        for (Map.Entry entry : this.catalogTypeMap.entrySet()) {
            String replace = ((String)entry.getKey()).replace("minecraft:", "").replace("sponge:", "").replace("debug_all_block_states", "debug");
            map.put(replace, (GeneratorType)entry.getValue());
        }
        return map;
    }

    private GeneratorTypeRegistryModule() {
        super("minecraft", new String[]{"minecraft", "sponge"}, id -> id.replace("debug_all_block_states", "debug"));
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(GeneratorType extraCatalog) {
        if (extraCatalog != null) {
            this.catalogTypeMap.put(extraCatalog.getId(), extraCatalog);
        }
    }

    private static final class Holder {
        static final GeneratorTypeRegistryModule INSTANCE = new GeneratorTypeRegistryModule();

        private Holder() {
        }
    }
}

