/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;

@RegistrationDependency(value={EntityTypeRegistryModule.class})
public class DungeonMobRegistryModule
implements RegistryModule {
    private final WeightedTable<EntityArchetype> dungeonMobs = new WeightedTable();
    private final List<EntityType> presentTypes = Lists.newArrayList();

    public static DungeonMobRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        Map<String, Long> types = Arrays.stream(WorldGenDungeons.field_175916_b).collect(Collectors.groupingBy(ResourceLocation::toString, Collectors.counting()));
        for (String mob : types.keySet()) {
            this.put(EntityUtil.fromNameToType(mob).get(), types.get(mob).intValue() * 100);
        }
    }

    public void put(EntityType type, int weight) {
        this.remove(type);
        this.dungeonMobs.add((TableEntry<EntityArchetype>)new WeightedSerializableObject<EntityArchetype>(EntityUtil.archetype(type), weight));
        this.presentTypes.add(type);
    }

    public void remove(EntityType type) {
        this.get(type).ifPresent(this.dungeonMobs::remove);
        this.presentTypes.remove(type);
    }

    public Optional<WeightedSerializableObject<EntityArchetype>> get(EntityType type) {
        return this.dungeonMobs.getEntries().stream().map(entry -> (WeightedSerializableObject)entry).findFirst();
    }

    public WeightedTable<EntityArchetype> getRaw() {
        return this.dungeonMobs;
    }

    private static final class Holder {
        static final DungeonMobRegistryModule INSTANCE = new DungeonMobRegistryModule();

        private Holder() {
        }
    }
}

