/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard.builder;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.scoreboard.ScorePlayerTeam;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public class SpongeTeamBuilder
implements Team.Builder {
    @Nullable
    private String name;
    @Nullable
    private Text displayName;
    private TextColor color;
    private Text prefix;
    private Text suffix;
    private boolean allowFriendlyFire;
    private boolean showFriendlyInvisibles;
    private Visibility nameTagVisibility;
    private Visibility deathMessageVisibility;
    private CollisionRule collisionRule;
    private Set<Text> members;

    public SpongeTeamBuilder() {
        this.reset();
    }

    @Override
    public Team.Builder name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null!");
        if (this.displayName == null) {
            this.displayName = Text.of(this.name);
        }
        return this;
    }

    @Override
    public Team.Builder color(TextColor color) {
        this.color = (TextColor)Preconditions.checkNotNull((Object)color, (Object)"Color cannot be null!");
        return this;
    }

    @Override
    public Team.Builder displayName(Text displayName) throws IllegalArgumentException {
        this.displayName = (Text)Preconditions.checkNotNull((Object)displayName, (Object)"DisplayName cannot be null!");
        return this;
    }

    @Override
    public Team.Builder prefix(Text prefix) {
        this.prefix = (Text)Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null!");
        return this;
    }

    @Override
    public Team.Builder suffix(Text suffix) {
        this.suffix = (Text)Preconditions.checkNotNull((Object)suffix, (Object)"Suffix cannot be null!");
        return this;
    }

    @Override
    public Team.Builder allowFriendlyFire(boolean enabled) {
        this.allowFriendlyFire = enabled;
        return this;
    }

    @Override
    public Team.Builder canSeeFriendlyInvisibles(boolean enabled) {
        this.showFriendlyInvisibles = enabled;
        return this;
    }

    @Override
    public Team.Builder nameTagVisibility(Visibility visibility) {
        this.nameTagVisibility = (Visibility)Preconditions.checkNotNull((Object)visibility, (Object)"Visibility cannot be null!");
        return this;
    }

    @Override
    public Team.Builder deathTextVisibility(Visibility visibility) {
        this.deathMessageVisibility = (Visibility)Preconditions.checkNotNull((Object)visibility, (Object)"Visibility cannot be null!");
        return this;
    }

    @Override
    public Team.Builder collisionRule(CollisionRule rule) {
        this.collisionRule = (CollisionRule)Preconditions.checkNotNull((Object)rule, (Object)"Collision rule cannot be null!");
        return this;
    }

    @Override
    public Team.Builder members(Set<Text> members) {
        this.members = new HashSet<Text>((Collection)Preconditions.checkNotNull(members, (Object)"Members cannot be null!"));
        return this;
    }

    @Override
    public Team.Builder from(Team value) {
        this.name(value.getName()).displayName(value.getDisplayName()).prefix(value.getPrefix()).color(value.getColor()).allowFriendlyFire(value.allowFriendlyFire()).canSeeFriendlyInvisibles(value.canSeeFriendlyInvisibles()).suffix(value.getSuffix()).nameTagVisibility(value.getNameTagVisibility()).deathTextVisibility(value.getDeathMessageVisibility()).collisionRule(value.getCollisionRule()).members(value.getMembers());
        return this;
    }

    @Override
    public SpongeTeamBuilder reset() {
        this.name = null;
        this.displayName = null;
        this.color = TextColors.RESET;
        this.prefix = Text.of();
        this.suffix = Text.of();
        this.allowFriendlyFire = false;
        this.showFriendlyInvisibles = false;
        this.nameTagVisibility = Visibilities.ALWAYS;
        this.deathMessageVisibility = Visibilities.ALWAYS;
        this.collisionRule = CollisionRules.ALWAYS;
        this.members = new HashSet<Text>();
        return this;
    }

    @Override
    public Team build() throws IllegalStateException {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Name cannot be null!");
        Preconditions.checkState((this.displayName != null ? 1 : 0) != 0, (Object)"DisplayName cannot be null!");
        Team team = (Team)new ScorePlayerTeam(null, this.name);
        team.setDisplayName(this.displayName);
        team.setColor(this.color);
        team.setPrefix(this.prefix);
        team.setSuffix(this.suffix);
        team.setAllowFriendlyFire(this.allowFriendlyFire);
        team.setCanSeeFriendlyInvisibles(this.showFriendlyInvisibles);
        team.setNameTagVisibility(this.nameTagVisibility);
        team.setDeathMessageVisibility(this.deathMessageVisibility);
        team.setCollisionRule(this.collisionRule);
        for (Text member : this.members) {
            team.addMember(member);
        }
        return team;
    }
}

