/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.pagination;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.StartsWithPredicate;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.service.pagination.ActivePagination;
import org.spongepowered.common.service.pagination.SpongePaginationBuilder;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;

public class SpongePaginationService
implements PaginationService {
    private final ConcurrentMap<MessageReceiver, SourcePaginations> activePaginations = new MapMaker().weakKeys().makeMap();
    private final Cache<UUID, SourcePaginations> playerActivePaginations = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final AtomicBoolean commandRegistered = new AtomicBoolean();

    void registerCommandOnce() {
        if (this.commandRegistered.compareAndSet(false, true)) {
            SpongeImpl.getGame().getCommandManager().register((Object)SpongeImpl.getPlugin(), (CommandCallable)this.buildPaginationCommand(), "pagination", "page");
        }
    }

    @Override
    public PaginationList.Builder builder() {
        return new SpongePaginationBuilder(this);
    }

    @Nullable
    SourcePaginations getPaginationState(MessageReceiver source, boolean create) {
        if (source instanceof Player) {
            return this.getPaginationStateForPlayer((Player)source, create);
        }
        return this.getPaginationStateForNonPlayer(source, create);
    }

    @Nullable
    private SourcePaginations getPaginationStateForNonPlayer(MessageReceiver source, boolean create) {
        SourcePaginations existing;
        SourcePaginations ret = (SourcePaginations)this.activePaginations.get(source);
        if (ret == null && create && (existing = this.activePaginations.putIfAbsent(source, ret = new SourcePaginations())) != null) {
            ret = existing;
        }
        return ret;
    }

    @Nullable
    private SourcePaginations getPaginationStateForPlayer(Player source, boolean create) {
        return this.playerActivePaginations.get(source.getUniqueId(), k -> create ? new SourcePaginations() : null);
    }

    private CommandSpec buildPaginationCommand() {
        ActivePaginationCommandElement paginationElement = new ActivePaginationCommandElement(SpongeCommonTranslationHelper.t("pagination-id", new Object[0]));
        CommandSpec next = CommandSpec.builder().description(SpongeCommonTranslationHelper.t("Go to the next page", new Object[0])).executor((src, args) -> {
            ((ActivePagination)args.getOne("pagination-id").get()).nextPage();
            return CommandResult.success();
        }).build();
        CommandSpec prev = CommandSpec.builder().description(SpongeCommonTranslationHelper.t("Go to the previous page", new Object[0])).executor((src, args) -> {
            ((ActivePagination)args.getOne("pagination-id").get()).previousPage();
            return CommandResult.success();
        }).build();
        CommandElement pageArgs = GenericArguments.integer(SpongeCommonTranslationHelper.t("page", new Object[0]));
        CommandExecutor pageExecutor = (src, args) -> {
            ((ActivePagination)args.getOne("pagination-id").get()).specificPage((Integer)args.getOne("page").get());
            return CommandResult.success();
        };
        CommandSpec page = CommandSpec.builder().description(SpongeCommonTranslationHelper.t("Go to a specific page", new Object[0])).arguments(pageArgs).executor(pageExecutor).build();
        ChildCommandElementExecutor childDispatcher = new ChildCommandElementExecutor(pageExecutor);
        childDispatcher.register((CommandCallable)next, "next", "n");
        childDispatcher.register((CommandCallable)prev, "prev", "p", "previous");
        childDispatcher.register((CommandCallable)page, "page");
        return CommandSpec.builder().arguments(paginationElement, GenericArguments.firstParsing(childDispatcher, pageArgs)).executor(childDispatcher).description(SpongeCommonTranslationHelper.t("Helper command for paginations occurring", new Object[0])).build();
    }

    private class ActivePaginationCommandElement
    extends CommandElement {
        protected ActivePaginationCommandElement(Text key) {
            super(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            UUID id;
            SourcePaginations paginations = SpongePaginationService.this.getPaginationState(source, false);
            if (paginations == null) {
                throw args.createError(SpongeCommonTranslationHelper.t("Source %s has no paginations!", source.getName()));
            }
            Object state = args.getState();
            try {
                id = UUID.fromString(args.next());
            }
            catch (IllegalArgumentException ex) {
                if (paginations.getLastUuid() != null) {
                    args.setState(state);
                    return paginations.get(paginations.getLastUuid());
                }
                throw args.createError(SpongeCommonTranslationHelper.t("Input was not a valid UUID!", new Object[0]));
            }
            ActivePagination pagination = paginations.get(id);
            if (pagination == null) {
                throw args.createError(SpongeCommonTranslationHelper.t("No pagination registered for id %s", id.toString()));
            }
            return paginations.get(id);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            SourcePaginations paginations = SpongePaginationService.this.getPaginationState(src, false);
            if (paginations == null) {
                return ImmutableList.of();
            }
            Optional<String> optNext = args.nextIfPresent();
            if (optNext.isPresent()) {
                return (List)paginations.keys().stream().map(Object::toString).filter(new StartsWithPredicate(optNext.get())).collect(ImmutableList.toImmutableList());
            }
            return ImmutableList.copyOf((Iterable)Iterables.transform(paginations.keys(), Object::toString));
        }

        @Override
        public Text getUsage(CommandSource src) {
            return this.getKey() == null ? Text.of() : Text.of("[", this.getKey(), "]");
        }
    }

    static class SourcePaginations {
        private final Map<UUID, ActivePagination> paginations = new ConcurrentHashMap<UUID, ActivePagination>();
        @Nullable
        private volatile UUID lastUuid;

        SourcePaginations() {
        }

        @Nullable
        public ActivePagination get(UUID uuid) {
            return this.paginations.get(uuid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(ActivePagination pagination) {
            Map<UUID, ActivePagination> map = this.paginations;
            synchronized (map) {
                this.paginations.put(pagination.getId(), pagination);
                this.lastUuid = pagination.getId();
            }
        }

        public Set<UUID> keys() {
            return this.paginations.keySet();
        }

        @Nullable
        public UUID getLastUuid() {
            return this.lastUuid;
        }
    }
}

