/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.text.selector.Argument;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.text.selector.SelectorResolver;

@NonnullByDefault
public class SpongeSelector
implements Selector {
    protected final SelectorType type;
    protected final ImmutableMap<ArgumentType<?>, Argument<?>> arguments;
    private final String plain;

    public SpongeSelector(SelectorType type, ImmutableMap<ArgumentType<?>, Argument<?>> arguments) {
        this.type = (SelectorType)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.arguments = (ImmutableMap)Preconditions.checkNotNull(arguments, (Object)"arguments");
        this.plain = this.buildString();
    }

    @Override
    public SelectorType getType() {
        return this.type;
    }

    @Override
    public <T> Optional<T> get(ArgumentType<T> type) {
        Argument argument = (Argument)this.arguments.get(type);
        return argument != null ? Optional.of(argument.getValue()) : Optional.empty();
    }

    @Override
    public <T> Optional<Argument<T>> getArgument(ArgumentType<T> type) {
        return Optional.ofNullable((Argument)this.arguments.get(type));
    }

    @Override
    public <T> Optional<Argument.Invertible<T>> getArgument(ArgumentType.Invertible<T> type) {
        return Optional.ofNullable((Argument.Invertible)this.arguments.get(type));
    }

    @Override
    public List<Argument<?>> getArguments() {
        return this.arguments.values().asList();
    }

    @Override
    public boolean has(ArgumentType<?> type) {
        return this.arguments.containsKey(type);
    }

    @Override
    public boolean isInverted(ArgumentType.Invertible<?> type) {
        if (!this.has(type)) {
            return false;
        }
        return ((Argument.Invertible)this.arguments.get(type)).isInverted();
    }

    @Override
    public Set<Entity> resolve(CommandSource origin) {
        return new SelectorResolver(origin, (Selector)this, false).resolve();
    }

    @Override
    public Set<Entity> resolve(Extent ... extents) {
        return this.resolve((Collection<? extends Extent>)ImmutableSet.copyOf((Object[])extents));
    }

    @Override
    public Set<Entity> resolve(Collection<? extends Extent> extents) {
        return new SelectorResolver(extents, (Selector)this, false).resolve();
    }

    @Override
    public Set<Entity> resolve(Location<World> location) {
        return new SelectorResolver(location, (Selector)this, false).resolve();
    }

    @Override
    public Set<Entity> resolveForce(CommandSource origin) {
        return new SelectorResolver(origin, (Selector)this, true).resolve();
    }

    @Override
    public Set<Entity> resolveForce(Extent ... extents) {
        return this.resolveForce((Collection<? extends Extent>)ImmutableSet.copyOf((Object[])extents));
    }

    @Override
    public Set<Entity> resolveForce(Collection<? extends Extent> extents) {
        return new SelectorResolver(extents, (Selector)this, true).resolve();
    }

    @Override
    public Set<Entity> resolveForce(Location<World> location) {
        return new SelectorResolver(location, (Selector)this, true).resolve();
    }

    @Override
    public String toPlain() {
        return this.plain;
    }

    @Override
    public Selector.Builder toBuilder() {
        return (Selector.Builder)Selector.builder().from(this);
    }

    private String buildString() {
        StringBuilder result = new StringBuilder();
        result.append('@').append(this.type.getId());
        if (!this.arguments.isEmpty()) {
            result.append('[');
            ImmutableCollection args = this.arguments.values();
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                Argument arg = (Argument)iter.next();
                result.append(arg.toPlain());
                if (!iter.hasNext()) continue;
                result.append(',');
            }
            result.append(']');
        }
        return result.toString();
    }
}

