/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.common.interfaces.world.gen.IFlaggedPopulator;

public class FilteredPopulator
implements IFlaggedPopulator {
    private final Populator wrapped;
    private final List<String> requiredFlags = Lists.newArrayList();
    private final Predicate<Extent> check;

    public FilteredPopulator(Populator w) {
        this(w, c -> true);
    }

    public FilteredPopulator(Populator w, Predicate<Extent> c) {
        this.wrapped = w;
        this.check = c;
    }

    public void setRequiredFlags(String ... flags) {
        this.requiredFlags.clear();
        for (String f : flags) {
            this.requiredFlags.add(f);
        }
    }

    @Override
    public PopulatorType getType() {
        return this.wrapped.getType();
    }

    @Override
    public void populate(World world, Extent volume, Random random) {
        this.wrapped.populate(world, volume, random);
    }

    @Override
    public void populate(World world, Extent extent, Random rand, ImmutableBiomeVolume virtualBiomes) {
        this.wrapped.populate(world, extent, rand, virtualBiomes);
    }

    @Override
    public void populate(World world, Extent extent, Random rand, List<String> flags) {
        if (!this.check.test(extent)) {
            return;
        }
        if (!flags.containsAll(this.requiredFlags)) {
            return;
        }
        this.wrapped.populate(world, extent, rand);
    }

    @Override
    public void populate(World world, Extent extent, Random rand, ImmutableBiomeVolume virtualBiomes, List<String> flags) {
        if (!this.check.test(extent)) {
            return;
        }
        if (!flags.containsAll(this.requiredFlags)) {
            return;
        }
        this.wrapped.populate(world, extent, rand, virtualBiomes);
    }
}

