/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBush;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Mushroom;
import org.spongepowered.api.world.gen.type.MushroomType;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.common.util.VecHelper;

public class HellMushroomPopulator
implements Mushroom {
    private final WorldGenBush feature = new WorldGenBush(null);
    private final Mushroom featureM = (Mushroom)this.feature;

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.MUSHROOM;
    }

    @Override
    public void populate(org.spongepowered.api.world.World world, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.featureM.getMushroomsPerChunk().getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            MushroomType type;
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            int y = random.nextInt(128);
            BlockPos height = chunkPos.func_177982_a(x, y, z);
            if (this.featureM.getSupplierOverride().isPresent()) {
                Location<Extent> pos2 = new Location<Extent>(extent, VecHelper.toVector3i(height));
                type = this.featureM.getSupplierOverride().get().apply(pos2);
            } else {
                List<MushroomType> result = this.featureM.getTypes().get(random);
                if (result.isEmpty()) continue;
                type = result.get(0);
            }
            this.feature.field_175908_a = type == MushroomTypes.BROWN ? Blocks.field_150338_P : Blocks.field_150337_Q;
            this.feature.func_180709_b((World)world, random, height);
        }
    }

    @Override
    public ChanceTable<MushroomType> getTypes() {
        return this.featureM.getTypes();
    }

    @Override
    public VariableAmount getMushroomsPerChunk() {
        return this.featureM.getMushroomsPerChunk();
    }

    @Override
    public void setMushroomsPerChunk(VariableAmount count) {
        this.featureM.setMushroomsPerChunk(count);
    }

    @Override
    public Optional<Function<Location<Extent>, MushroomType>> getSupplierOverride() {
        return this.featureM.getSupplierOverride();
    }

    @Override
    public void setSupplierOverride(Function<Location<Extent>, MushroomType> override) {
        this.featureM.setSupplierOverride(override);
    }
}

