/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModMetadata;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.mod.SpongeCoremod;

public final class SpongeModMetadata {
    @Nullable
    private static MetadataCollection metadata;

    private SpongeModMetadata() {
    }

    public static void load() {
        if (metadata != null) {
            return;
        }
        try {
            String source = SpongeCoremod.modFile.toURI().toString();
            boolean isJar = source.endsWith(".jar");
            Enumeration<URL> urls = SpongeModMetadata.class.getClassLoader().getResources("mcmod.info");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (isJar ? !"jar".equals(url.getProtocol()) || !url.getPath().startsWith(source) : !"file".equals(url.getProtocol())) continue;
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    metadata = MetadataCollection.from((InputStream)in, (String)url.toString());
                    ModMetadata meta = SpongeModMetadata.getSpongeForgeMetadata();
                    if (meta.autogenerated) continue;
                    SpongeImpl.getLogger().info("Found mcmod.info at {}", (Object)url);
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            SpongeImpl.getLogger().warn("Failed to load metadata", (Throwable)e);
        }
        if (metadata == null) {
            metadata = new MetadataCollection();
        }
    }

    public static ModMetadata get(String modId, String name) {
        SpongeModMetadata.load();
        ModMetadata meta = metadata.getMetadataForId(modId, (Map)ImmutableMap.of((Object)"name", (Object)name, (Object)"version", (Object)""));
        if (!meta.autogenerated) {
            if (meta.name == null) {
                meta.name = name;
            }
            if (meta.version == null) {
                meta.version = "";
            }
        }
        return meta;
    }

    public static ModMetadata getSpongeForgeMetadata() {
        return SpongeModMetadata.get("sponge", "SpongeForge");
    }
}

