/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.SleepingEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.event.world.chunk.LoadChunkEvent;
import org.spongepowered.api.event.world.chunk.UnloadChunkEvent;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.mod.event.ForgeToSpongeEventData;
import org.spongepowered.mod.event.SpongeModEventManager;
import org.spongepowered.mod.interfaces.IMixinBlockSnapshot;
import org.spongepowered.mod.interfaces.IMixinNetPlayHandler;

public class ForgeToSpongeEventFactory {
    static final CauseStackManager causeStackManager = Sponge.getCauseStackManager();
    static final SpongeModEventManager eventManager = (SpongeModEventManager)Sponge.getEventManager();
    public static final ImmutableMap<Class<? extends net.minecraftforge.fml.common.eventhandler.Event>, Class<? extends Event>> forgeToSpongeClassMap = new ImmutableMap.Builder().put(BlockEvent.BreakEvent.class, ChangeBlockEvent.Pre.class).put(BlockEvent.MultiPlaceEvent.class, ChangeBlockEvent.Place.class).put(BlockEvent.PlaceEvent.class, ChangeBlockEvent.Place.class).put(ExplosionEvent.Detonate.class, ExplosionEvent.Detonate.class).put(PlayerInteractEvent.LeftClickBlock.class, InteractBlockEvent.Primary.class).put(PlayerInteractEvent.RightClickBlock.class, InteractBlockEvent.Secondary.class).put(PlayerInteractEvent.RightClickItem.class, InteractItemEvent.Secondary.class).put(PlayerSleepInBedEvent.class, SleepingEvent.Pre.class).put(ServerChatEvent.class, MessageChannelEvent.Chat.class).build();

    public static Class<? extends Event> getSpongeClass(net.minecraftforge.fml.common.eventhandler.Event event) {
        if (event instanceof PlayerInteractEvent) {
            if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                PlayerInteractEvent.LeftClickBlock forgeEvent = (PlayerInteractEvent.LeftClickBlock)event;
                if (forgeEvent.getHand() == EnumHand.MAIN_HAND) {
                    return InteractBlockEvent.Primary.MainHand.class;
                }
                return InteractBlockEvent.Primary.OffHand.class;
            }
            if (event instanceof PlayerInteractEvent.RightClickBlock) {
                PlayerInteractEvent.RightClickBlock forgeEvent = (PlayerInteractEvent.RightClickBlock)event;
                if (forgeEvent.getHand() == EnumHand.MAIN_HAND) {
                    return InteractBlockEvent.Secondary.MainHand.class;
                }
                return InteractBlockEvent.Secondary.OffHand.class;
            }
            if (event instanceof PlayerInteractEvent.RightClickItem) {
                PlayerInteractEvent.RightClickItem forgeEvent = (PlayerInteractEvent.RightClickItem)event;
                if (forgeEvent.getHand() == EnumHand.MAIN_HAND) {
                    return InteractItemEvent.Secondary.MainHand.class;
                }
                return InteractItemEvent.Secondary.OffHand.class;
            }
        }
        return (Class)forgeToSpongeClassMap.get(event.getClass());
    }

    private static Tristate getTristateFromResult(Event.Result result) {
        if (result == Event.Result.ALLOW) {
            return Tristate.TRUE;
        }
        if (result == Event.Result.DENY) {
            return Tristate.FALSE;
        }
        return Tristate.UNDEFINED;
    }

    public static Event createAndPostSpongeEvent(ForgeToSpongeEventData eventData) {
        net.minecraftforge.fml.common.eventhandler.Event forgeEvent = eventData.getForgeEvent();
        if (forgeEvent instanceof BlockEvent.MultiPlaceEvent) {
            return ForgeToSpongeEventFactory.createAndPostChangeBlockEventPlaceMulti(eventData);
        }
        if (forgeEvent instanceof BlockEvent.PlaceEvent) {
            return ForgeToSpongeEventFactory.createAndPostChangeBlockEventPlace(eventData);
        }
        if (forgeEvent instanceof BlockEvent.BreakEvent) {
            return ForgeToSpongeEventFactory.createAndPostChangeBlockEventPre(eventData);
        }
        if (forgeEvent instanceof ServerChatEvent) {
            return ForgeToSpongeEventFactory.createAndPostMessageChannelEventChat(eventData);
        }
        if (forgeEvent instanceof PlayerSleepInBedEvent) {
            return ForgeToSpongeEventFactory.createAndPostSleepingEventPre(eventData);
        }
        if (forgeEvent instanceof PlayerInteractEvent) {
            if (forgeEvent instanceof PlayerInteractEvent.LeftClickBlock) {
                return ForgeToSpongeEventFactory.createAndPostInteractBlockPrimaryEvent(eventData);
            }
            if (forgeEvent instanceof PlayerInteractEvent.RightClickBlock) {
                return ForgeToSpongeEventFactory.createAndPostInteractBlockSecondaryEvent(eventData);
            }
            if (forgeEvent instanceof PlayerInteractEvent.RightClickItem) {
                return ForgeToSpongeEventFactory.createAndPostInteractItemSecondaryEvent(eventData);
            }
        }
        if (forgeEvent instanceof ExplosionEvent.Detonate) {
            return ForgeToSpongeEventFactory.createAndPostExplosionEventDetonate(eventData);
        }
        return null;
    }

    private static ExplosionEvent.Detonate createAndPostExplosionEventDetonate(ForgeToSpongeEventData eventData) {
        ExplosionEvent.Detonate spongeEvent = (ExplosionEvent.Detonate)eventData.getSpongeEvent();
        ExplosionEvent.Detonate forgeEvent = (ExplosionEvent.Detonate)eventData.getForgeEvent();
        ArrayList<Location<World>> blockPositions = new ArrayList<Location<World>>(forgeEvent.getAffectedBlocks().size());
        ArrayList<Entity> entities = new ArrayList<Entity>(forgeEvent.getAffectedEntities().size());
        for (BlockPos blockPos : forgeEvent.getAffectedBlocks()) {
            blockPositions.add(new Location<World>((World)forgeEvent.getWorld(), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
        }
        for (net.minecraft.entity.Entity entity : forgeEvent.getAffectedEntities()) {
            entities.add((Entity)entity);
        }
        spongeEvent = SpongeEventFactory.createExplosionEventDetonate(causeStackManager.getCurrentCause(), blockPositions, entities, (Explosion)forgeEvent.getExplosion(), (World)forgeEvent.getWorld());
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        if (spongeEvent.isCancelled()) {
            forgeEvent.getAffectedBlocks().clear();
            forgeEvent.getAffectedEntities().clear();
        }
        if (forgeEvent.getAffectedBlocks().size() != spongeEvent.getAffectedLocations().size()) {
            forgeEvent.getAffectedBlocks().clear();
            for (Location location : spongeEvent.getAffectedLocations()) {
                forgeEvent.getAffectedBlocks().add(VecHelper.toBlockPos(location));
            }
        }
        if (forgeEvent.getAffectedEntities().size() != spongeEvent.getEntities().size()) {
            forgeEvent.getAffectedEntities().clear();
            for (Entity entity : spongeEvent.getEntities()) {
                forgeEvent.getAffectedEntities().add((net.minecraft.entity.Entity)entity);
            }
        }
        return spongeEvent;
    }

    private static ChangeBlockEvent.Pre createAndPostChangeBlockEventPre(ForgeToSpongeEventData eventData) {
        BlockEvent.BreakEvent forgeEvent = (BlockEvent.BreakEvent)eventData.getForgeEvent();
        net.minecraft.world.World world = forgeEvent.getWorld();
        if (world.field_72995_K) {
            return null;
        }
        BlockPos pos = forgeEvent.getPos();
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData data = phaseTracker.getCurrentPhaseData();
        EntityPlayer player = forgeEvent.getPlayer();
        User owner = data.context.getOwner().orElse((User)player);
        User notifier = data.context.getNotifier().orElse((User)player);
        if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
            causeStackManager.addContext(EventContextKeys.FAKE_PLAYER, EntityUtil.toPlayer(player));
        } else {
            causeStackManager.addContext(EventContextKeys.OWNER, owner);
            causeStackManager.addContext(EventContextKeys.NOTIFIER, notifier);
        }
        causeStackManager.addContext(EventContextKeys.PLAYER_BREAK, (World)world);
        ChangeBlockEvent.Pre spongeEvent = SpongeEventFactory.createChangeBlockEventPre(causeStackManager.getCurrentCause(), (List)ImmutableList.of(new Location<World>((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())));
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    private static ChangeBlockEvent.Place createAndPostChangeBlockEventPlace(ForgeToSpongeEventData eventData) {
        BlockEvent.PlaceEvent forgeEvent = (BlockEvent.PlaceEvent)eventData.getForgeEvent();
        BlockPos pos = forgeEvent.getPos();
        net.minecraft.world.World world = forgeEvent.getWorld();
        if (world.field_72995_K) {
            return null;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData data = phaseTracker.getCurrentPhaseData();
        org.spongepowered.api.block.BlockSnapshot originalSnapshot = ((IMixinBlockSnapshot)forgeEvent.getBlockSnapshot()).createSpongeBlockSnapshot();
        org.spongepowered.api.block.BlockSnapshot finalSnapshot = ((BlockState)forgeEvent.getPlacedBlock()).snapshotFor(new Location<World>((World)world, VecHelper.toVector3d(pos)));
        ImmutableList blockSnapshots = new ImmutableList.Builder().add(new Transaction<org.spongepowered.api.block.BlockSnapshot>(originalSnapshot, finalSnapshot)).build();
        EntityPlayer player = forgeEvent.getPlayer();
        User owner = data.context.getOwner().orElse((User)player);
        User notifier = data.context.getNotifier().orElse((User)player);
        if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
            causeStackManager.addContext(EventContextKeys.FAKE_PLAYER, EntityUtil.toPlayer(player));
        } else {
            causeStackManager.addContext(EventContextKeys.OWNER, owner);
            causeStackManager.addContext(EventContextKeys.NOTIFIER, notifier);
        }
        causeStackManager.addContext(EventContextKeys.PLAYER_PLACE, (World)world);
        ChangeBlockEvent.Place spongeEvent = SpongeEventFactory.createChangeBlockEventPlace(causeStackManager.getCurrentCause(), (List)blockSnapshots);
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    private static ChangeBlockEvent.Place createAndPostChangeBlockEventPlaceMulti(ForgeToSpongeEventData eventData) {
        BlockEvent.MultiPlaceEvent forgeEvent = (BlockEvent.MultiPlaceEvent)eventData.getForgeEvent();
        net.minecraft.world.World world = forgeEvent.getWorld();
        if (world.field_72995_K) {
            return null;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (BlockSnapshot blockSnapshot : forgeEvent.getReplacedBlockSnapshots()) {
            BlockPos snapshotPos = blockSnapshot.getPos();
            org.spongepowered.api.block.BlockSnapshot originalSnapshot = ((IMixinBlockSnapshot)blockSnapshot).createSpongeBlockSnapshot();
            org.spongepowered.api.block.BlockSnapshot finalSnapshot = ((World)world).createSnapshot(snapshotPos.func_177958_n(), snapshotPos.func_177956_o(), snapshotPos.func_177952_p());
            builder.add(new Transaction<org.spongepowered.api.block.BlockSnapshot>(originalSnapshot, finalSnapshot));
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData data = phaseTracker.getCurrentPhaseData();
        EntityPlayer player = forgeEvent.getPlayer();
        User owner = data.context.getOwner().orElse((User)player);
        User notifier = data.context.getNotifier().orElse((User)player);
        if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
            causeStackManager.addContext(EventContextKeys.FAKE_PLAYER, EntityUtil.toPlayer(player));
        } else {
            causeStackManager.addContext(EventContextKeys.OWNER, owner);
            causeStackManager.addContext(EventContextKeys.NOTIFIER, notifier);
        }
        causeStackManager.addContext(EventContextKeys.PLAYER_PLACE, (World)world);
        ChangeBlockEvent.Place spongeEvent = SpongeEventFactory.createChangeBlockEventPlace(causeStackManager.getCurrentCause(), (List)builder.build());
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    private static MessageChannelEvent.Chat createAndPostMessageChannelEventChat(ForgeToSpongeEventData eventData) {
        MessageChannel channel;
        ServerChatEvent forgeEvent = (ServerChatEvent)eventData.getForgeEvent();
        ITextComponent forgeComponent = forgeEvent.getComponent();
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter();
        Text[] chat = SpongeTexts.splitChatMessage(forgeComponent);
        if (chat[1] == null) {
            chat[1] = chat[0] != null ? chat[0] : SpongeTexts.toText(forgeComponent);
            chat[0] = null;
        }
        if (chat[0] != null) {
            formatter.getHeader().add(new MessageEvent.DefaultHeaderApplier(chat[0]));
        }
        formatter.getBody().add(new MessageEvent.DefaultBodyApplier(chat[1]));
        LiteralText rawSpongeMessage = Text.of(forgeEvent.getMessage());
        MessageChannel originalChannel = channel = ((Player)forgeEvent.getPlayer()).getMessageChannel();
        causeStackManager.pushCause(forgeEvent.getPlayer());
        MessageChannelEvent.Chat spongeEvent = SpongeEventFactory.createMessageChannelEventChat(causeStackManager.getCurrentCause(), originalChannel, Optional.ofNullable(channel), formatter, rawSpongeMessage, false);
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        ITextComponent spongeComponent = SpongeTexts.toComponent(spongeEvent.getMessage());
        if (!spongeComponent.equals(forgeEvent.getComponent())) {
            forgeEvent.setComponent(spongeComponent);
        }
        return spongeEvent;
    }

    private static SleepingEvent.Pre createAndPostSleepingEventPre(ForgeToSpongeEventData eventData) {
        PlayerSleepInBedEvent forgeEvent = (PlayerSleepInBedEvent)eventData.getForgeEvent();
        net.minecraft.world.World world = forgeEvent.getEntity().func_130014_f_();
        if (world.field_72995_K) {
            return null;
        }
        BlockPos pos = forgeEvent.getPos();
        org.spongepowered.api.block.BlockSnapshot bedSnapshot = ((World)world).createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        causeStackManager.pushCause(forgeEvent.getEntity());
        SleepingEvent.Pre spongeEvent = SpongeEventFactory.createSleepingEventPre(causeStackManager.getCurrentCause(), bedSnapshot, (Entity)forgeEvent.getEntity());
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    private static LoadChunkEvent createAndPostLoadChunkEvent(ForgeToSpongeEventData eventData) {
        boolean isMainThread;
        ChunkEvent.Load forgeEvent = (ChunkEvent.Load)eventData.getForgeEvent();
        boolean bl = isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        if (isMainThread) {
            causeStackManager.pushCause(forgeEvent.getWorld());
        }
        Cause cause = isMainThread ? causeStackManager.getCurrentCause() : Cause.of(EventContext.empty(), forgeEvent.getWorld());
        LoadChunkEvent spongeEvent = SpongeEventFactory.createLoadChunkEvent(cause, (Chunk)forgeEvent.getChunk());
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    private static UnloadChunkEvent createAndPostUnloadChunkEvent(ForgeToSpongeEventData eventData) {
        boolean isMainThread;
        ChunkEvent.Unload forgeEvent = (ChunkEvent.Unload)eventData.getForgeEvent();
        boolean bl = isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        if (isMainThread) {
            causeStackManager.pushCause(forgeEvent.getWorld());
        }
        Cause cause = isMainThread ? causeStackManager.getCurrentCause() : Cause.of(EventContext.empty(), forgeEvent.getWorld());
        UnloadChunkEvent spongeEvent = SpongeEventFactory.createUnloadChunkEvent(cause, (Chunk)forgeEvent.getChunk());
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    private static InteractItemEvent.Secondary createAndPostInteractItemSecondaryEvent(ForgeToSpongeEventData eventData) {
        PlayerInteractEvent.RightClickItem forgeEvent = (PlayerInteractEvent.RightClickItem)eventData.getForgeEvent();
        EntityPlayerMP player = (EntityPlayerMP)forgeEvent.getEntityPlayer();
        ItemStack heldItem = forgeEvent.getItemStack();
        BlockPos pos = forgeEvent.getPos();
        EnumFacing face = forgeEvent.getFace();
        Direction direction = face == null ? Direction.NONE : DirectionFacingProvider.getInstance().getKey(face).get();
        org.spongepowered.api.block.BlockSnapshot currentSnapshot = org.spongepowered.api.block.BlockSnapshot.NONE;
        RayTraceResult result = SpongeImplHooks.rayTraceEyes((EntityLivingBase)player, SpongeImplHooks.getBlockReachDistance(player));
        if (result != null) {
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                causeStackManager.addContext(EventContextKeys.ENTITY_HIT, (Entity)result.field_72308_g);
            } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                currentSnapshot = ((World)player.field_70170_p).createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                causeStackManager.addContext(EventContextKeys.BLOCK_HIT, currentSnapshot);
            }
        }
        Vector3d hitVec = result == null ? null : VecHelper.toVector3d(result.field_72307_f);
        InteractItemEvent.Secondary spongeEvent = forgeEvent.getHand() == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractItemEventSecondaryMainHand(causeStackManager.getCurrentCause(), HandTypes.MAIN_HAND, Optional.ofNullable(hitVec), ItemStackUtil.snapshotOf(heldItem)) : SpongeEventFactory.createInteractItemEventSecondaryOffHand(causeStackManager.getCurrentCause(), HandTypes.OFF_HAND, Optional.ofNullable(hitVec), ItemStackUtil.snapshotOf(heldItem));
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        if (spongeEvent.isCancelled()) {
            player.func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
        }
        return spongeEvent;
    }

    private static InteractBlockEvent.Primary createAndPostInteractBlockPrimaryEvent(ForgeToSpongeEventData eventData) {
        PlayerInteractEvent.LeftClickBlock forgeEvent = (PlayerInteractEvent.LeftClickBlock)eventData.getForgeEvent();
        EntityPlayerMP player = (EntityPlayerMP)forgeEvent.getEntityPlayer();
        BlockPos pos = forgeEvent.getPos();
        org.spongepowered.api.block.BlockSnapshot blockSnapshot = ((World)forgeEvent.getWorld()).createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        EnumFacing face = forgeEvent.getFace();
        Direction direction = face == null ? Direction.NONE : DirectionFacingProvider.getInstance().getKey(face).get();
        InteractBlockEvent.Primary spongeEvent = forgeEvent.getHand() == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractBlockEventPrimaryMainHand(Sponge.getCauseStackManager().getCurrentCause(), HandTypes.MAIN_HAND, Optional.ofNullable(VecHelper.toVector3d(forgeEvent.getHitVec())), blockSnapshot, direction) : SpongeEventFactory.createInteractBlockEventPrimaryOffHand(Sponge.getCauseStackManager().getCurrentCause(), HandTypes.OFF_HAND, Optional.ofNullable(VecHelper.toVector3d(forgeEvent.getHitVec())), blockSnapshot, direction);
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    private static InteractBlockEvent.Secondary createAndPostInteractBlockSecondaryEvent(ForgeToSpongeEventData eventData) {
        PlayerInteractEvent.RightClickBlock forgeEvent = (PlayerInteractEvent.RightClickBlock)eventData.getForgeEvent();
        EntityPlayer player = forgeEvent.getEntityPlayer();
        HandType hand = forgeEvent.getHand() == EnumHand.MAIN_HAND ? HandTypes.MAIN_HAND : HandTypes.OFF_HAND;
        Tristate useBlockResult = ForgeToSpongeEventFactory.getTristateFromResult(forgeEvent.getUseBlock());
        Tristate useItemResult = ForgeToSpongeEventFactory.getTristateFromResult(forgeEvent.getUseItem());
        Vector3d interactionPoint = VecHelper.toVector3d(forgeEvent.getHitVec());
        BlockPos pos = forgeEvent.getPos();
        org.spongepowered.api.block.BlockSnapshot blockSnapshot = ((World)forgeEvent.getWorld()).createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        Direction direction = DirectionFacingProvider.getInstance().getKey(forgeEvent.getFace()).get();
        InteractBlockEvent.Secondary spongeEvent = null;
        spongeEvent = hand == HandTypes.MAIN_HAND ? SpongeEventFactory.createInteractBlockEventSecondaryMainHand(causeStackManager.getCurrentCause(), useBlockResult, useBlockResult, useItemResult, useItemResult, hand, Optional.ofNullable(interactionPoint), blockSnapshot, direction) : SpongeEventFactory.createInteractBlockEventSecondaryOffHand(causeStackManager.getCurrentCause(), useBlockResult, useBlockResult, useItemResult, useItemResult, hand, Optional.ofNullable(interactionPoint), blockSnapshot, direction);
        eventData.setSpongeEvent(spongeEvent);
        eventManager.postEvent(eventData);
        return spongeEvent;
    }

    public static void onPostEnd(ForgeToSpongeEventData eventData) {
        if (eventData.getForgeEvent() instanceof ServerChatEvent) {
            MessageChannelEvent.Chat spongeEvent = (MessageChannelEvent.Chat)eventData.getSpongeEvent();
            ServerChatEvent forgeEvent = (ServerChatEvent)eventData.getForgeEvent();
            EntityPlayerMP player = forgeEvent.getPlayer();
            if (!spongeEvent.isCancelled()) {
                Text message = spongeEvent.getMessage();
                if (!spongeEvent.isMessageCancelled()) {
                    spongeEvent.getChannel().ifPresent(channel -> channel.send(forgeEvent.getPlayer(), message, ChatTypes.CHAT));
                }
            }
            int chatSpamThresholdCount = ((IMixinNetPlayHandler)player.field_71135_a).getChatSpamThresholdCount() + 20;
            ((IMixinNetPlayHandler)player.field_71135_a).setChatSpamThresholdCount(chatSpamThresholdCount);
            if (chatSpamThresholdCount > 200 && !SpongeImpl.getServer().func_184103_al().func_152596_g(player.func_146103_bH())) {
                player.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("disconnect.spam", new Object[0]));
            }
            forgeEvent.setComponent(null);
        } else if (eventData.getForgeEvent() instanceof PlayerInteractEvent.RightClickItem && !eventData.getForgeEvent().isCanceled()) {
            PlayerInteractEvent.RightClickItem forgeEvent = (PlayerInteractEvent.RightClickItem)eventData.getForgeEvent();
            BlockPos pos = forgeEvent.getPos();
            EnumFacing face = forgeEvent.getFace();
            ItemStack heldItem = forgeEvent.getItemStack();
            Vector3d hitVec = VecHelper.toVector3d(new BlockPos((net.minecraft.entity.Entity)forgeEvent.getEntityPlayer()));
            org.spongepowered.api.block.BlockSnapshot blockSnapshot = ((World)forgeEvent.getWorld()).createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            Direction direction = face == null ? Direction.NONE : DirectionFacingProvider.getInstance().getKey(face).get();
            SpongeImpl.postEvent(SpongeCommonEventFactory.createInteractBlockEventSecondary(forgeEvent.getEntityPlayer(), heldItem, hitVec, blockSnapshot, direction, forgeEvent.getHand()));
        }
    }
}

