/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.server.timings.TimeTracker;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.command.SpongeCommandFactory;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.interfaces.entity.IMixinEntityLivingBase;
import org.spongepowered.common.interfaces.world.IMixinDimensionType;
import org.spongepowered.common.interfaces.world.IMixinITeleporter;
import org.spongepowered.common.item.inventory.util.InventoryUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.registry.type.world.PortalAgentRegistryModule;
import org.spongepowered.common.util.SpawnerSpawnType;
import org.spongepowered.mod.command.SpongeForgeCommand;
import org.spongepowered.mod.interfaces.IMixinBlock;
import org.spongepowered.mod.interfaces.IMixinEventBus;
import org.spongepowered.mod.interfaces.IMixinVillagerProfession;
import org.spongepowered.mod.item.inventory.adapter.IItemHandlerAdapter;
import org.spongepowered.mod.mixin.core.forge.IMixinVillagerRegistry;
import org.spongepowered.mod.plugin.SpongeModPluginContainer;
import org.spongepowered.mod.util.StaticMixinForgeHelper;
import org.spongepowered.mod.util.WrappedArrayList;

@Mixin(value={SpongeImplHooks.class}, remap=false)
public abstract class MixinSpongeImplHooks {
    private static Boolean deobfuscatedEnvironment;

    @Overwrite
    public static boolean isVanilla() {
        return false;
    }

    @Overwrite
    public static boolean isClientAvailable() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    @Overwrite
    public static boolean isDeobfuscatedEnvironment() {
        if (deobfuscatedEnvironment != null) {
            return deobfuscatedEnvironment;
        }
        deobfuscatedEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return deobfuscatedEnvironment;
    }

    @Overwrite
    public static String getModIdFromClass(Class<?> clazz) {
        return StaticMixinForgeHelper.getModIdFromClass(clazz);
    }

    @Overwrite
    public static boolean isCreatureOfType(Entity entity, EnumCreatureType type) {
        return entity.isCreatureType(type, false);
    }

    @Overwrite
    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    @Overwrite
    public static void firePlayerJoinSpawnEvent(EntityPlayerMP playerMP) {
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((Event)new EntityJoinWorldEvent((Entity)playerMP, playerMP.func_130014_f_()), true);
    }

    @Overwrite
    public static void handlePostChangeDimensionEvent(EntityPlayerMP playerIn, WorldServer fromWorld, WorldServer toWorld) {
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)playerIn, fromWorld.field_73011_w.getDimension(), toWorld.field_73011_w.getDimension());
    }

    @Overwrite
    public static boolean checkAttackEntity(EntityPlayer entityPlayer, Entity targetEntity) {
        return ForgeHooks.onPlayerAttackTarget((EntityPlayer)entityPlayer, (Entity)targetEntity);
    }

    @Overwrite
    public static double getBlockReachDistance(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @Nullable
    @Overwrite
    public static Class<? extends Entity> getEntityClass(ResourceLocation name) {
        return EntityList.getClass((ResourceLocation)name);
    }

    @Overwrite
    public static int getEntityId(Class<? extends Entity> entityClass) {
        return EntityList.getID(entityClass);
    }

    @Overwrite
    public static boolean isBlockFlammable(Block block, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return block.isFlammable(world, pos, face);
    }

    @Overwrite
    public static int getBlockLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.getLightOpacity(world, pos);
    }

    @Overwrite
    public static int getChunkPosLight(IBlockState blockState, net.minecraft.world.World worldObj, BlockPos pos) {
        if (((IMixinBlock)blockState.func_177230_c()).requiresLocationCheckForLightValue()) {
            return blockState.getLightValue((IBlockAccess)worldObj, pos);
        }
        return blockState.func_185906_d();
    }

    @Nullable
    @Overwrite
    public static TileEntity createTileEntity(Block block, net.minecraft.world.World world, IBlockState state) {
        return block.createTileEntity(world, state);
    }

    @Overwrite
    public static boolean hasBlockTileEntity(Block block, IBlockState state) {
        return block.hasTileEntity(state);
    }

    @Overwrite
    public static boolean shouldRefresh(TileEntity tile, net.minecraft.world.World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return tile.shouldRefresh(world, pos, oldState, newState);
    }

    @Overwrite
    public static void onTileChunkUnload(TileEntity te) {
        if (!te.func_145831_w().field_72995_K) {
            try (Object o = ((PhaseContext)BlockPhase.State.TILE_CHUNK_UNLOAD.createPhaseContext()).source(te);){
                ((PhaseContext)o).buildAndSwitch();
                te.onChunkUnload();
            }
        }
    }

    @Overwrite
    public static Iterator<Chunk> getChunkIterator(WorldServer world) {
        return world.getPersistentChunkIterable(world.func_184164_w().func_187300_b());
    }

    @Overwrite
    public static void registerPortalAgentType(@Nullable IMixinITeleporter teleporter) {
        if (teleporter == null) {
            return;
        }
        if (PortalAgentTypes.DEFAULT.equals(((PortalAgent)((Object)teleporter)).getType())) {
            return;
        }
        PortalAgentRegistryModule.getInstance().validatePortalAgent(teleporter);
    }

    @Overwrite
    public static boolean canDoLightning(WorldProvider provider, Chunk chunk) {
        return provider.canDoLightning(chunk);
    }

    @Overwrite
    public static boolean canDoRainSnowIce(WorldProvider provider, Chunk chunk) {
        return provider.canDoRainSnowIce(chunk);
    }

    @Overwrite
    public static int getRespawnDimension(WorldProvider targetDimension, EntityPlayerMP player) {
        return targetDimension.getRespawnDimension(player);
    }

    @Overwrite
    public static BlockPos getRandomizedSpawnPoint(WorldServer world) {
        return world.field_73011_w.getRandomizedSpawnPoint();
    }

    @Overwrite
    public static MapStorage getWorldMapStorage(net.minecraft.world.World world) {
        return world.getPerWorldStorage();
    }

    @Overwrite
    public static int countEntities(WorldServer worldServer, EnumCreatureType type, boolean forSpawnCount) {
        return worldServer.countEntities(type, forSpawnCount);
    }

    @Overwrite
    public static int getMaxSpawnPackSize(EntityLiving entityLiving) {
        return ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityLiving);
    }

    @Overwrite
    public static SpawnerSpawnType canEntitySpawnHere(EntityLiving entityLiving, boolean entityNotColliding) {
        net.minecraft.world.World world = entityLiving.field_70170_p;
        float x = (float)entityLiving.field_70165_t;
        float y = (float)entityLiving.field_70163_u;
        float z = (float)entityLiving.field_70161_v;
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (net.minecraft.world.World)world, (float)x, (float)y, (float)z, (boolean)false);
        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityLiving.func_70601_bi() && entityNotColliding) {
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (net.minecraft.world.World)world, (float)x, (float)y, (float)z)) {
                return SpawnerSpawnType.NORMAL;
            }
            return SpawnerSpawnType.SPECIAL;
        }
        return SpawnerSpawnType.NONE;
    }

    @Overwrite
    public static void onEntityError(Entity entity, CrashReport crashReport) {
        if (!ForgeModContainer.removeErroringEntities) {
            throw new ReportedException(crashReport);
        }
        FMLRelaunchLog.log.getLogger().log(Level.ERROR, crashReport.func_71502_e());
        entity.func_130014_f_().func_72900_e(entity);
    }

    @Overwrite
    public static void onTileEntityError(TileEntity tileEntity, CrashReport crashReport) {
        if (!ForgeModContainer.removeErroringTileEntities) {
            throw new ReportedException(crashReport);
        }
        FMLRelaunchLog.log.getLogger().log(Level.ERROR, crashReport.func_71502_e());
        tileEntity.func_145843_s();
        tileEntity.func_145831_w().func_175713_t(tileEntity.func_174877_v());
    }

    @Overwrite
    public static void blockExploded(Block block, net.minecraft.world.World world, BlockPos blockpos, Explosion explosion) {
        block.onBlockExploded(world, blockpos, explosion);
    }

    @Overwrite
    public static boolean isRestoringBlocks(net.minecraft.world.World world) {
        return world.restoringBlockSnapshots || PhaseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS;
    }

    @Overwrite
    public static void onTileEntityChunkUnload(TileEntity tileEntity) {
        tileEntity.onChunkUnload();
    }

    @Overwrite
    public static boolean canConnectRedstone(Block block, IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return block.canConnectRedstone(state, world, pos, side);
    }

    @Overwrite
    public static void setShouldLoadSpawn(DimensionType dimensionType, boolean keepSpawnLoaded) {
        ((IMixinDimensionType)dimensionType).setShouldLoadSpawn(keepSpawnLoaded);
    }

    @Overwrite
    public static BlockPos getBedLocation(EntityPlayer player, int dimension) {
        return player.getBedLocation(dimension);
    }

    @Overwrite
    public static boolean isSpawnForced(EntityPlayer player, int dimension) {
        return player.isSpawnForced(dimension);
    }

    @Overwrite
    public static Optional<org.spongepowered.api.item.inventory.ItemStack> getContainerItem(org.spongepowered.api.item.inventory.ItemStack itemStack) {
        ItemStack nmsStack = ItemStackUtil.toNative(itemStack);
        ItemStack nmsContainerStack = ForgeHooks.getContainerItem((ItemStack)nmsStack);
        if (nmsContainerStack.func_190926_b()) {
            return Optional.empty();
        }
        return Optional.of(ItemStackUtil.fromNative(nmsContainerStack));
    }

    @Overwrite
    public static void onCraftingRecipeRegister(CraftingRecipe recipe) {
    }

    @Overwrite
    public static Optional<CraftingRecipe> findMatchingRecipe(CraftingGridInventory inventory, World world) {
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)InventoryUtil.toNativeInventory(inventory), (net.minecraft.world.World)((net.minecraft.world.World)world));
        return Optional.ofNullable((CraftingRecipe)recipe);
    }

    @Overwrite
    public static Collection<CraftingRecipe> getCraftingRecipes() {
        return (Collection)Streams.stream((Collection)ForgeRegistries.RECIPES.getValues()).map(CraftingRecipe.class::cast).collect(ImmutableList.toImmutableList());
    }

    @Overwrite
    public static Optional<CraftingRecipe> getRecipeById(String id) {
        IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(id));
        if (recipe == null) {
            return Optional.empty();
        }
        return Optional.of((CraftingRecipe)recipe);
    }

    @Overwrite
    public static Text getAdditionalCommandDescriptions() {
        return Text.of("    ", SpongeCommandFactory.title("mods"), "        ", "List currently installed mods");
    }

    @Overwrite
    public static void registerAdditionalCommands(ChildCommandElementExecutor flagChildren, ChildCommandElementExecutor nonFlagChildren) {
        nonFlagChildren.register((CommandCallable)SpongeForgeCommand.createSpongeModsCommand(), "mods");
    }

    @Overwrite
    public static Predicate<PluginContainer> getPluginFilterPredicate() {
        return plugin -> !SpongeCommandFactory.CONTAINER_LIST_STATICS.contains(plugin.getId()) && plugin instanceof SpongeModPluginContainer;
    }

    @Overwrite
    public static Inventory toInventory(Object inventory, @Nullable Object fallback) {
        if (inventory instanceof IInventory) {
            return (Inventory)new InvWrapper((IInventory)inventory);
        }
        if (fallback instanceof IItemHandler) {
            return new IItemHandlerAdapter((IItemHandler)fallback);
        }
        String fallbackName = fallback == null ? "no fallback" : fallback.getClass().getName();
        SpongeImpl.getLogger().error("Unknown inventory " + inventory.getClass().getName() + " and " + fallbackName + " report this to Sponge");
        return null;
    }

    @Overwrite
    public static void onTileEntityInvalidate(TileEntity te) {
        try (Object o = ((PhaseContext)BlockPhase.State.TILE_ENTITY_INVALIDATING.createPhaseContext()).source(te);){
            ((PhaseContext)o).buildAndSwitch();
            te.func_145843_s();
        }
    }

    @Overwrite
    public static void capturePerEntityItemDrop(PhaseContext<?> phaseContext, Entity owner, EntityItem entityitem) {
        ArrayList capturedDrops = owner.capturedDrops;
        ArrayListMultimap<UUID, EntityItem> map = phaseContext.getPerEntityItemEntityDropSupplier().get();
        WrappedArrayList entityItems = new WrappedArrayList(owner, map.get((Object)owner.func_110124_au()));
        if (capturedDrops != entityItems) {
            owner.capturedDrops = entityItems;
            if (!capturedDrops.isEmpty()) {
                ((ArrayList)entityItems).addAll(capturedDrops);
            }
        }
        ((ArrayList)entityItems).add(entityitem);
    }

    @Overwrite
    public static int getLootingEnchantmentModifier(IMixinEntityLivingBase mixinEntityLivingBase, EntityLivingBase entity, DamageSource cause) {
        return ForgeHooks.getLootingLevel((Entity)EntityUtil.toNative(mixinEntityLivingBase), (Entity)entity, (DamageSource)cause);
    }

    @Overwrite
    public static Profession validateProfession(int professionId) {
        VillagerRegistry.VillagerProfession profession = (VillagerRegistry.VillagerProfession)((IMixinVillagerRegistry)VillagerRegistry.instance()).getREGISTRY().func_148754_a(professionId);
        if (profession == null) {
            throw new RuntimeException("Attempted to set villager profession to unregistered profession: " + professionId + " " + profession);
        }
        IMixinVillagerProfession mixinProfession = (IMixinVillagerProfession)profession;
        return mixinProfession.getSpongeProfession().orElseGet(() -> {
            SpongeProfession newProfession = new SpongeProfession(professionId, mixinProfession.getId(), mixinProfession.getProfessionName());
            mixinProfession.setSpongeProfession(newProfession);
            ProfessionRegistryModule.getInstance().registerAdditionalCatalog(newProfession);
            return newProfession;
        });
    }

    @Overwrite
    public static void onUseItemTick(EntityLivingBase entity, ItemStack stack, int activeItemStackUseCount) {
        if (!stack.func_190926_b() && activeItemStackUseCount > 0) {
            stack.func_77973_b().onUsingTick(stack, entity, activeItemStackUseCount);
        }
    }

    @Overwrite
    public static void onTETickStart(TileEntity tileentity) {
        TimeTracker.TILE_ENTITY_UPDATE.trackStart((Object)tileentity);
    }

    @Overwrite
    public static void onTETickEnd(TileEntity tileentity) {
        TimeTracker.TILE_ENTITY_UPDATE.trackEnd((Object)tileentity);
    }

    @Overwrite
    public static void onEntityTickStart(Entity entity) {
        TimeTracker.ENTITY_UPDATE.trackStart((Object)entity);
    }

    @Overwrite
    public static void onEntityTickEnd(Entity entity) {
        TimeTracker.ENTITY_UPDATE.trackEnd((Object)entity);
    }
}

