/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.server;

import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.mod.service.world.SpongeChunkTicketManager;

@Mixin(value={MinecraftServer.class}, priority=1001)
public abstract class MixinMinecraftServer
implements Server,
IMixinMinecraftServer {
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    @Final
    private Snooper field_71307_n;
    public ChunkTicketManager chunkTicketManager = new SpongeChunkTicketManager();
    @Shadow(remap=false)
    public Hashtable<Integer, long[]> worldTickTimes;
    @Shadow
    private boolean field_71296_Q;

    @Override
    public long[] getWorldTickTimes(int dimensionId) {
        return this.worldTickTimes.get(dimensionId);
    }

    @Override
    public void putWorldTickTimes(int dimensionId, long[] tickTimes) {
        this.worldTickTimes.put(dimensionId, tickTimes);
    }

    @Override
    public void removeWorldTickTimes(int dimensionId) {
        this.worldTickTimes.remove(dimensionId);
    }

    @Override
    public ChunkTicketManager getChunkTicketManager() {
        return this.chunkTicketManager;
    }

    @Inject(method={"updateTimeLightAndEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;updateEntities()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onPostUpdateEntities(CallbackInfo ci, Integer[] ids, int x, int id, long i, WorldServer worldServer) {
        IMixinWorldServer spongeWorld = (IMixinWorldServer)worldServer;
        if (spongeWorld.getChunkGCTickInterval() > 0) {
            spongeWorld.doChunkGC();
        }
    }

    @Overwrite
    public WorldServer func_71218_a(int dimensionId) {
        WorldServer ret = WorldManager.getWorldByDimensionId(dimensionId).orElse(null);
        if (ret == null) {
            DimensionManager.initDimension((int)dimensionId);
            ret = WorldManager.getWorldByDimensionId(dimensionId).orElse(null);
        }
        if (ret == null) {
            return WorldManager.getWorldByDimensionId(0).orElseThrow(() -> new RuntimeException("Attempt made to initialize dimension before overworld is loaded!"));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_71260_j() {
        field_147145_h.info("Stopping server");
        ((MinecraftServer)this).func_152358_ax().func_152658_c();
        MinecraftServer server = (MinecraftServer)this;
        if (server.func_147137_ag() != null) {
            server.func_147137_ag().func_151268_b();
        }
        if (server.func_184103_al() != null) {
            field_147145_h.info("Saving players");
            server.func_184103_al().func_72389_g();
            server.func_184103_al().func_72392_r();
        }
        if (server.field_71305_c != null) {
            field_147145_h.info("Saving worlds");
            for (WorldServer worldserver : server.field_71305_c) {
                if (worldserver == null) continue;
                worldserver.field_73058_d = false;
            }
            server.func_71267_a(false);
            for (WorldServer worldserver1 : server.field_71305_c) {
                if (worldserver1 == null) continue;
                if (SpongeImpl.getGlobalConfig().getConfig().getModules().useOptimizations() && SpongeImpl.getGlobalConfig().getConfig().getOptimizations().useAsyncLighting()) {
                    ((IMixinWorldServer)worldserver1).getLightingExecutor().shutdown();
                    try {
                        ((IMixinWorldServer)worldserver1).getLightingExecutor().awaitTermination(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        ((IMixinWorldServer)worldserver1).getLightingExecutor().shutdownNow();
                    }
                }
                WorldManager.unloadWorld(worldserver1, false);
                worldserver1.func_73041_k();
            }
        }
        if (this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
    }
}

